/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputRequestDestinationRoute;
import software.amazon.awssdk.services.medialive.model.___listOfInputRequestDestinationRouteCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDestinationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDestinationRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(InputDestinationRequest.getter(InputDestinationRequest::streamName)).setter(InputDestinationRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Network").getter(InputDestinationRequest.getter(InputDestinationRequest::network)).setter(InputDestinationRequest.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<List<InputRequestDestinationRoute>> NETWORK_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkRoutes").getter(InputDestinationRequest.getter(InputDestinationRequest::networkRoutes)).setter(InputDestinationRequest.setter(Builder::networkRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputRequestDestinationRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticIpAddress").getter(InputDestinationRequest.getter(InputDestinationRequest::staticIpAddress)).setter(InputDestinationRequest.setter(Builder::staticIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticIpAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, NETWORK_FIELD, NETWORK_ROUTES_FIELD, STATIC_IP_ADDRESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamName;
    private final String network;
    private final List<InputRequestDestinationRoute> networkRoutes;
    private final String staticIpAddress;

    private InputDestinationRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.network = builder.network;
        this.networkRoutes = builder.networkRoutes;
        this.staticIpAddress = builder.staticIpAddress;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String network() {
        return this.network;
    }

    public final boolean hasNetworkRoutes() {
        return this.networkRoutes != null && !(this.networkRoutes instanceof SdkAutoConstructList);
    }

    public final List<InputRequestDestinationRoute> networkRoutes() {
        return this.networkRoutes;
    }

    public final String staticIpAddress() {
        return this.staticIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.network());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkRoutes() ? this.networkRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.staticIpAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestinationRequest)) {
            return false;
        }
        InputDestinationRequest other = (InputDestinationRequest)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.network(), other.network()) && this.hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(this.networkRoutes(), other.networkRoutes()) && Objects.equals(this.staticIpAddress(), other.staticIpAddress());
    }

    public final String toString() {
        return ToString.builder((String)"InputDestinationRequest").add("StreamName", (Object)this.streamName()).add("Network", (Object)this.network()).add("NetworkRoutes", this.hasNetworkRoutes() ? this.networkRoutes() : null).add("StaticIpAddress", (Object)this.staticIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Network": {
                return Optional.ofNullable(clazz.cast(this.network()));
            }
            case "NetworkRoutes": {
                return Optional.ofNullable(clazz.cast(this.networkRoutes()));
            }
            case "StaticIpAddress": {
                return Optional.ofNullable(clazz.cast(this.staticIpAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDestinationRequest, T> g) {
        return obj -> g.apply((InputDestinationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String network;
        private List<InputRequestDestinationRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();
        private String staticIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestinationRequest model) {
            this.streamName(model.streamName);
            this.network(model.network);
            this.networkRoutes(model.networkRoutes);
            this.staticIpAddress(model.staticIpAddress);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final List<InputRequestDestinationRoute.Builder> getNetworkRoutes() {
            List<InputRequestDestinationRoute.Builder> result = ___listOfInputRequestDestinationRouteCopier.copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<InputRequestDestinationRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = ___listOfInputRequestDestinationRouteCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        public final Builder networkRoutes(Collection<InputRequestDestinationRoute> networkRoutes) {
            this.networkRoutes = ___listOfInputRequestDestinationRouteCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(InputRequestDestinationRoute ... networkRoutes) {
            this.networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(Consumer<InputRequestDestinationRoute.Builder> ... networkRoutes) {
            this.networkRoutes(Stream.of(networkRoutes).map(c -> (InputRequestDestinationRoute)((InputRequestDestinationRoute.Builder)InputRequestDestinationRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStaticIpAddress() {
            return this.staticIpAddress;
        }

        public final void setStaticIpAddress(String staticIpAddress) {
            this.staticIpAddress = staticIpAddress;
        }

        @Override
        public final Builder staticIpAddress(String staticIpAddress) {
            this.staticIpAddress = staticIpAddress;
            return this;
        }

        public InputDestinationRequest build() {
            return new InputDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDestinationRequest> {
        public Builder streamName(String var1);

        public Builder network(String var1);

        public Builder networkRoutes(Collection<InputRequestDestinationRoute> var1);

        public Builder networkRoutes(InputRequestDestinationRoute ... var1);

        public Builder networkRoutes(Consumer<InputRequestDestinationRoute.Builder> ... var1);

        public Builder staticIpAddress(String var1);
    }
}

