/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfCloudWatchAlarmTemplateSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCloudWatchAlarmTemplatesResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListCloudWatchAlarmTemplatesResponse> {
    private static final SdkField<List<CloudWatchAlarmTemplateSummary>> CLOUD_WATCH_ALARM_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudWatchAlarmTemplates").getter(ListCloudWatchAlarmTemplatesResponse.getter(ListCloudWatchAlarmTemplatesResponse::cloudWatchAlarmTemplates)).setter(ListCloudWatchAlarmTemplatesResponse.setter(Builder::cloudWatchAlarmTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchAlarmTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCloudWatchAlarmTemplatesResponse.getter(ListCloudWatchAlarmTemplatesResponse::nextToken)).setter(ListCloudWatchAlarmTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ALARM_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cloudWatchAlarmTemplates", CLOUD_WATCH_ALARM_TEMPLATES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates;
    private final String nextToken;

    private ListCloudWatchAlarmTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplates = builder.cloudWatchAlarmTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCloudWatchAlarmTemplates() {
        return this.cloudWatchAlarmTemplates != null && !(this.cloudWatchAlarmTemplates instanceof SdkAutoConstructList);
    }

    public final List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates() {
        return this.cloudWatchAlarmTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudWatchAlarmTemplates() ? this.cloudWatchAlarmTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudWatchAlarmTemplatesResponse)) {
            return false;
        }
        ListCloudWatchAlarmTemplatesResponse other = (ListCloudWatchAlarmTemplatesResponse)((Object)obj);
        return this.hasCloudWatchAlarmTemplates() == other.hasCloudWatchAlarmTemplates() && Objects.equals(this.cloudWatchAlarmTemplates(), other.cloudWatchAlarmTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCloudWatchAlarmTemplatesResponse").add("CloudWatchAlarmTemplates", this.hasCloudWatchAlarmTemplates() ? this.cloudWatchAlarmTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchAlarmTemplates": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCloudWatchAlarmTemplatesResponse, T> g) {
        return obj -> g.apply((ListCloudWatchAlarmTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudWatchAlarmTemplatesResponse model) {
            super(model);
            this.cloudWatchAlarmTemplates(model.cloudWatchAlarmTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<CloudWatchAlarmTemplateSummary.Builder> getCloudWatchAlarmTemplates() {
            List<CloudWatchAlarmTemplateSummary.Builder> result = ___listOfCloudWatchAlarmTemplateSummaryCopier.copyToBuilder(this.cloudWatchAlarmTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchAlarmTemplates(Collection<CloudWatchAlarmTemplateSummary.BuilderImpl> cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates = ___listOfCloudWatchAlarmTemplateSummaryCopier.copyFromBuilder(cloudWatchAlarmTemplates);
        }

        @Override
        public final Builder cloudWatchAlarmTemplates(Collection<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates = ___listOfCloudWatchAlarmTemplateSummaryCopier.copy(cloudWatchAlarmTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplates(CloudWatchAlarmTemplateSummary ... cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates(Arrays.asList(cloudWatchAlarmTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplates(Consumer<CloudWatchAlarmTemplateSummary.Builder> ... cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates(Stream.of(cloudWatchAlarmTemplates).map(c -> (CloudWatchAlarmTemplateSummary)((CloudWatchAlarmTemplateSummary.Builder)CloudWatchAlarmTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCloudWatchAlarmTemplatesResponse build() {
            return new ListCloudWatchAlarmTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCloudWatchAlarmTemplatesResponse> {
        public Builder cloudWatchAlarmTemplates(Collection<CloudWatchAlarmTemplateSummary> var1);

        public Builder cloudWatchAlarmTemplates(CloudWatchAlarmTemplateSummary ... var1);

        public Builder cloudWatchAlarmTemplates(Consumer<CloudWatchAlarmTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

