/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.SrtCallerDecryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtCallerSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtCallerSource> {
    private static final SdkField<SrtCallerDecryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Decryption").getter(SrtCallerSource.getter(SrtCallerSource::decryption)).setter(SrtCallerSource.setter(Builder::decryption)).constructor(SrtCallerDecryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<Integer> MINIMUM_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumLatency").getter(SrtCallerSource.getter(SrtCallerSource::minimumLatency)).setter(SrtCallerSource.setter(Builder::minimumLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatency").build()}).build();
    private static final SdkField<String> SRT_LISTENER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SrtListenerAddress").getter(SrtCallerSource.getter(SrtCallerSource::srtListenerAddress)).setter(SrtCallerSource.setter(Builder::srtListenerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerAddress").build()}).build();
    private static final SdkField<String> SRT_LISTENER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SrtListenerPort").getter(SrtCallerSource.getter(SrtCallerSource::srtListenerPort)).setter(SrtCallerSource.setter(Builder::srtListenerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerPort").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(SrtCallerSource.getter(SrtCallerSource::streamId)).setter(SrtCallerSource.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD, MINIMUM_LATENCY_FIELD, SRT_LISTENER_ADDRESS_FIELD, SRT_LISTENER_PORT_FIELD, STREAM_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("decryption", DECRYPTION_FIELD);
            this.put("minimumLatency", MINIMUM_LATENCY_FIELD);
            this.put("srtListenerAddress", SRT_LISTENER_ADDRESS_FIELD);
            this.put("srtListenerPort", SRT_LISTENER_PORT_FIELD);
            this.put("streamId", STREAM_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SrtCallerDecryption decryption;
    private final Integer minimumLatency;
    private final String srtListenerAddress;
    private final String srtListenerPort;
    private final String streamId;

    private SrtCallerSource(BuilderImpl builder) {
        this.decryption = builder.decryption;
        this.minimumLatency = builder.minimumLatency;
        this.srtListenerAddress = builder.srtListenerAddress;
        this.srtListenerPort = builder.srtListenerPort;
        this.streamId = builder.streamId;
    }

    public final SrtCallerDecryption decryption() {
        return this.decryption;
    }

    public final Integer minimumLatency() {
        return this.minimumLatency;
    }

    public final String srtListenerAddress() {
        return this.srtListenerAddress;
    }

    public final String srtListenerPort() {
        return this.srtListenerPort;
    }

    public final String streamId() {
        return this.streamId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListenerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.srtListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerSource)) {
            return false;
        }
        SrtCallerSource other = (SrtCallerSource)obj;
        return Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.minimumLatency(), other.minimumLatency()) && Objects.equals(this.srtListenerAddress(), other.srtListenerAddress()) && Objects.equals(this.srtListenerPort(), other.srtListenerPort()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"SrtCallerSource").add("Decryption", (Object)this.decryption()).add("MinimumLatency", (Object)this.minimumLatency()).add("SrtListenerAddress", (Object)this.srtListenerAddress()).add("SrtListenerPort", (Object)this.srtListenerPort()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "MinimumLatency": {
                return Optional.ofNullable(clazz.cast(this.minimumLatency()));
            }
            case "SrtListenerAddress": {
                return Optional.ofNullable(clazz.cast(this.srtListenerAddress()));
            }
            case "SrtListenerPort": {
                return Optional.ofNullable(clazz.cast(this.srtListenerPort()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerSource, T> g) {
        return obj -> g.apply((SrtCallerSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SrtCallerDecryption decryption;
        private Integer minimumLatency;
        private String srtListenerAddress;
        private String srtListenerPort;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerSource model) {
            this.decryption(model.decryption);
            this.minimumLatency(model.minimumLatency);
            this.srtListenerAddress(model.srtListenerAddress);
            this.srtListenerPort(model.srtListenerPort);
            this.streamId(model.streamId);
        }

        public final SrtCallerDecryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        public final void setDecryption(SrtCallerDecryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        public final Builder decryption(SrtCallerDecryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final Integer getMinimumLatency() {
            return this.minimumLatency;
        }

        public final void setMinimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
        }

        @Override
        public final Builder minimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
            return this;
        }

        public final String getSrtListenerAddress() {
            return this.srtListenerAddress;
        }

        public final void setSrtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
        }

        @Override
        public final Builder srtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
            return this;
        }

        public final String getSrtListenerPort() {
            return this.srtListenerPort;
        }

        public final void setSrtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
        }

        @Override
        public final Builder srtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public SrtCallerSource build() {
            return new SrtCallerSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtCallerSource> {
        public Builder decryption(SrtCallerDecryption var1);

        default public Builder decryption(Consumer<SrtCallerDecryption.Builder> decryption) {
            return this.decryption((SrtCallerDecryption)((SrtCallerDecryption.Builder)SrtCallerDecryption.builder().applyMutation(decryption)).build());
        }

        public Builder minimumLatency(Integer var1);

        public Builder srtListenerAddress(String var1);

        public Builder srtListenerPort(String var1);

        public Builder streamId(String var1);
    }
}

