/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.DeviceSettingsSyncState;
import software.amazon.awssdk.services.medialive.model.DeviceUpdateStatus;
import software.amazon.awssdk.services.medialive.model.InputDeviceConnectionState;
import software.amazon.awssdk.services.medialive.model.InputDeviceHdSettings;
import software.amazon.awssdk.services.medialive.model.InputDeviceNetworkSettings;
import software.amazon.awssdk.services.medialive.model.InputDeviceOutputType;
import software.amazon.awssdk.services.medialive.model.InputDeviceType;
import software.amazon.awssdk.services.medialive.model.InputDeviceUhdSettings;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(InputDeviceSummary.getter(InputDeviceSummary::arn)).setter(InputDeviceSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(InputDeviceSummary.getter(InputDeviceSummary::connectionStateAsString)).setter(InputDeviceSummary.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final SdkField<String> DEVICE_SETTINGS_SYNC_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceSettingsSyncState").getter(InputDeviceSummary.getter(InputDeviceSummary::deviceSettingsSyncStateAsString)).setter(InputDeviceSummary.setter(Builder::deviceSettingsSyncState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceSettingsSyncState").build()}).build();
    private static final SdkField<String> DEVICE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceUpdateStatus").getter(InputDeviceSummary.getter(InputDeviceSummary::deviceUpdateStatusAsString)).setter(InputDeviceSummary.setter(Builder::deviceUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceUpdateStatus").build()}).build();
    private static final SdkField<InputDeviceHdSettings> HD_DEVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HdDeviceSettings").getter(InputDeviceSummary.getter(InputDeviceSummary::hdDeviceSettings)).setter(InputDeviceSummary.setter(Builder::hdDeviceSettings)).constructor(InputDeviceHdSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdDeviceSettings").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(InputDeviceSummary.getter(InputDeviceSummary::id)).setter(InputDeviceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(InputDeviceSummary.getter(InputDeviceSummary::macAddress)).setter(InputDeviceSummary.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InputDeviceSummary.getter(InputDeviceSummary::name)).setter(InputDeviceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<InputDeviceNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkSettings").getter(InputDeviceSummary.getter(InputDeviceSummary::networkSettings)).setter(InputDeviceSummary.setter(Builder::networkSettings)).constructor(InputDeviceNetworkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()}).build();
    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SerialNumber").getter(InputDeviceSummary.getter(InputDeviceSummary::serialNumber)).setter(InputDeviceSummary.setter(Builder::serialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(InputDeviceSummary.getter(InputDeviceSummary::typeAsString)).setter(InputDeviceSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<InputDeviceUhdSettings> UHD_DEVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UhdDeviceSettings").getter(InputDeviceSummary.getter(InputDeviceSummary::uhdDeviceSettings)).setter(InputDeviceSummary.setter(Builder::uhdDeviceSettings)).constructor(InputDeviceUhdSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uhdDeviceSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(InputDeviceSummary.getter(InputDeviceSummary::tags)).setter(InputDeviceSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(InputDeviceSummary.getter(InputDeviceSummary::availabilityZone)).setter(InputDeviceSummary.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<List<String>> MEDIALIVE_INPUT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MedialiveInputArns").getter(InputDeviceSummary.getter(InputDeviceSummary::medialiveInputArns)).setter(InputDeviceSummary.setter(Builder::medialiveInputArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("medialiveInputArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(InputDeviceSummary.getter(InputDeviceSummary::outputTypeAsString)).setter(InputDeviceSummary.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONNECTION_STATE_FIELD, DEVICE_SETTINGS_SYNC_STATE_FIELD, DEVICE_UPDATE_STATUS_FIELD, HD_DEVICE_SETTINGS_FIELD, ID_FIELD, MAC_ADDRESS_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, SERIAL_NUMBER_FIELD, TYPE_FIELD, UHD_DEVICE_SETTINGS_FIELD, TAGS_FIELD, AVAILABILITY_ZONE_FIELD, MEDIALIVE_INPUT_ARNS_FIELD, OUTPUT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("connectionState", CONNECTION_STATE_FIELD);
            this.put("deviceSettingsSyncState", DEVICE_SETTINGS_SYNC_STATE_FIELD);
            this.put("deviceUpdateStatus", DEVICE_UPDATE_STATUS_FIELD);
            this.put("hdDeviceSettings", HD_DEVICE_SETTINGS_FIELD);
            this.put("id", ID_FIELD);
            this.put("macAddress", MAC_ADDRESS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("networkSettings", NETWORK_SETTINGS_FIELD);
            this.put("serialNumber", SERIAL_NUMBER_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("uhdDeviceSettings", UHD_DEVICE_SETTINGS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
            this.put("medialiveInputArns", MEDIALIVE_INPUT_ARNS_FIELD);
            this.put("outputType", OUTPUT_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String connectionState;
    private final String deviceSettingsSyncState;
    private final String deviceUpdateStatus;
    private final InputDeviceHdSettings hdDeviceSettings;
    private final String id;
    private final String macAddress;
    private final String name;
    private final InputDeviceNetworkSettings networkSettings;
    private final String serialNumber;
    private final String type;
    private final InputDeviceUhdSettings uhdDeviceSettings;
    private final Map<String, String> tags;
    private final String availabilityZone;
    private final List<String> medialiveInputArns;
    private final String outputType;

    private InputDeviceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.connectionState = builder.connectionState;
        this.deviceSettingsSyncState = builder.deviceSettingsSyncState;
        this.deviceUpdateStatus = builder.deviceUpdateStatus;
        this.hdDeviceSettings = builder.hdDeviceSettings;
        this.id = builder.id;
        this.macAddress = builder.macAddress;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.serialNumber = builder.serialNumber;
        this.type = builder.type;
        this.uhdDeviceSettings = builder.uhdDeviceSettings;
        this.tags = builder.tags;
        this.availabilityZone = builder.availabilityZone;
        this.medialiveInputArns = builder.medialiveInputArns;
        this.outputType = builder.outputType;
    }

    public final String arn() {
        return this.arn;
    }

    public final InputDeviceConnectionState connectionState() {
        return InputDeviceConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final DeviceSettingsSyncState deviceSettingsSyncState() {
        return DeviceSettingsSyncState.fromValue(this.deviceSettingsSyncState);
    }

    public final String deviceSettingsSyncStateAsString() {
        return this.deviceSettingsSyncState;
    }

    public final DeviceUpdateStatus deviceUpdateStatus() {
        return DeviceUpdateStatus.fromValue(this.deviceUpdateStatus);
    }

    public final String deviceUpdateStatusAsString() {
        return this.deviceUpdateStatus;
    }

    public final InputDeviceHdSettings hdDeviceSettings() {
        return this.hdDeviceSettings;
    }

    public final String id() {
        return this.id;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String name() {
        return this.name;
    }

    public final InputDeviceNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final InputDeviceType type() {
        return InputDeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final InputDeviceUhdSettings uhdDeviceSettings() {
        return this.uhdDeviceSettings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasMedialiveInputArns() {
        return this.medialiveInputArns != null && !(this.medialiveInputArns instanceof SdkAutoConstructList);
    }

    public final List<String> medialiveInputArns() {
        return this.medialiveInputArns;
    }

    public final InputDeviceOutputType outputType() {
        return InputDeviceOutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSettingsSyncStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uhdDeviceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMedialiveInputArns() ? this.medialiveInputArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceSummary)) {
            return false;
        }
        InputDeviceSummary other = (InputDeviceSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.deviceSettingsSyncStateAsString(), other.deviceSettingsSyncStateAsString()) && Objects.equals(this.deviceUpdateStatusAsString(), other.deviceUpdateStatusAsString()) && Objects.equals(this.hdDeviceSettings(), other.hdDeviceSettings()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkSettings(), other.networkSettings()) && Objects.equals(this.serialNumber(), other.serialNumber()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.uhdDeviceSettings(), other.uhdDeviceSettings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasMedialiveInputArns() == other.hasMedialiveInputArns() && Objects.equals(this.medialiveInputArns(), other.medialiveInputArns()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InputDeviceSummary").add("Arn", (Object)this.arn()).add("ConnectionState", (Object)this.connectionStateAsString()).add("DeviceSettingsSyncState", (Object)this.deviceSettingsSyncStateAsString()).add("DeviceUpdateStatus", (Object)this.deviceUpdateStatusAsString()).add("HdDeviceSettings", (Object)this.hdDeviceSettings()).add("Id", (Object)this.id()).add("MacAddress", (Object)this.macAddress()).add("Name", (Object)this.name()).add("NetworkSettings", (Object)this.networkSettings()).add("SerialNumber", (Object)this.serialNumber()).add("Type", (Object)this.typeAsString()).add("UhdDeviceSettings", (Object)this.uhdDeviceSettings()).add("Tags", this.hasTags() ? this.tags() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("MedialiveInputArns", this.hasMedialiveInputArns() ? this.medialiveInputArns() : null).add("OutputType", (Object)this.outputTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "DeviceSettingsSyncState": {
                return Optional.ofNullable(clazz.cast(this.deviceSettingsSyncStateAsString()));
            }
            case "DeviceUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceUpdateStatusAsString()));
            }
            case "HdDeviceSettings": {
                return Optional.ofNullable(clazz.cast(this.hdDeviceSettings()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkSettings": {
                return Optional.ofNullable(clazz.cast(this.networkSettings()));
            }
            case "SerialNumber": {
                return Optional.ofNullable(clazz.cast(this.serialNumber()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "UhdDeviceSettings": {
                return Optional.ofNullable(clazz.cast(this.uhdDeviceSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MedialiveInputArns": {
                return Optional.ofNullable(clazz.cast(this.medialiveInputArns()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceSummary, T> g) {
        return obj -> g.apply((InputDeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String connectionState;
        private String deviceSettingsSyncState;
        private String deviceUpdateStatus;
        private InputDeviceHdSettings hdDeviceSettings;
        private String id;
        private String macAddress;
        private String name;
        private InputDeviceNetworkSettings networkSettings;
        private String serialNumber;
        private String type;
        private InputDeviceUhdSettings uhdDeviceSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String availabilityZone;
        private List<String> medialiveInputArns = DefaultSdkAutoConstructList.getInstance();
        private String outputType;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceSummary model) {
            this.arn(model.arn);
            this.connectionState(model.connectionState);
            this.deviceSettingsSyncState(model.deviceSettingsSyncState);
            this.deviceUpdateStatus(model.deviceUpdateStatus);
            this.hdDeviceSettings(model.hdDeviceSettings);
            this.id(model.id);
            this.macAddress(model.macAddress);
            this.name(model.name);
            this.networkSettings(model.networkSettings);
            this.serialNumber(model.serialNumber);
            this.type(model.type);
            this.uhdDeviceSettings(model.uhdDeviceSettings);
            this.tags(model.tags);
            this.availabilityZone(model.availabilityZone);
            this.medialiveInputArns(model.medialiveInputArns);
            this.outputType(model.outputType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(InputDeviceConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getDeviceSettingsSyncState() {
            return this.deviceSettingsSyncState;
        }

        public final void setDeviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
        }

        @Override
        public final Builder deviceSettingsSyncState(String deviceSettingsSyncState) {
            this.deviceSettingsSyncState = deviceSettingsSyncState;
            return this;
        }

        @Override
        public final Builder deviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState) {
            this.deviceSettingsSyncState(deviceSettingsSyncState == null ? null : deviceSettingsSyncState.toString());
            return this;
        }

        public final String getDeviceUpdateStatus() {
            return this.deviceUpdateStatus;
        }

        public final void setDeviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
        }

        @Override
        public final Builder deviceUpdateStatus(String deviceUpdateStatus) {
            this.deviceUpdateStatus = deviceUpdateStatus;
            return this;
        }

        @Override
        public final Builder deviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus) {
            this.deviceUpdateStatus(deviceUpdateStatus == null ? null : deviceUpdateStatus.toString());
            return this;
        }

        public final InputDeviceHdSettings.Builder getHdDeviceSettings() {
            return this.hdDeviceSettings != null ? this.hdDeviceSettings.toBuilder() : null;
        }

        public final void setHdDeviceSettings(InputDeviceHdSettings.BuilderImpl hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings != null ? hdDeviceSettings.build() : null;
        }

        @Override
        public final Builder hdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
            this.hdDeviceSettings = hdDeviceSettings;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InputDeviceNetworkSettings.Builder getNetworkSettings() {
            return this.networkSettings != null ? this.networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(InputDeviceNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(InputDeviceNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final InputDeviceUhdSettings.Builder getUhdDeviceSettings() {
            return this.uhdDeviceSettings != null ? this.uhdDeviceSettings.toBuilder() : null;
        }

        public final void setUhdDeviceSettings(InputDeviceUhdSettings.BuilderImpl uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings != null ? uhdDeviceSettings.build() : null;
        }

        @Override
        public final Builder uhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings) {
            this.uhdDeviceSettings = uhdDeviceSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Collection<String> getMedialiveInputArns() {
            if (this.medialiveInputArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.medialiveInputArns;
        }

        public final void setMedialiveInputArns(Collection<String> medialiveInputArns) {
            this.medialiveInputArns = ___listOf__stringCopier.copy(medialiveInputArns);
        }

        @Override
        public final Builder medialiveInputArns(Collection<String> medialiveInputArns) {
            this.medialiveInputArns = ___listOf__stringCopier.copy(medialiveInputArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder medialiveInputArns(String ... medialiveInputArns) {
            this.medialiveInputArns(Arrays.asList(medialiveInputArns));
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(InputDeviceOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public InputDeviceSummary build() {
            return new InputDeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceSummary> {
        public Builder arn(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(InputDeviceConnectionState var1);

        public Builder deviceSettingsSyncState(String var1);

        public Builder deviceSettingsSyncState(DeviceSettingsSyncState var1);

        public Builder deviceUpdateStatus(String var1);

        public Builder deviceUpdateStatus(DeviceUpdateStatus var1);

        public Builder hdDeviceSettings(InputDeviceHdSettings var1);

        default public Builder hdDeviceSettings(Consumer<InputDeviceHdSettings.Builder> hdDeviceSettings) {
            return this.hdDeviceSettings((InputDeviceHdSettings)((InputDeviceHdSettings.Builder)InputDeviceHdSettings.builder().applyMutation(hdDeviceSettings)).build());
        }

        public Builder id(String var1);

        public Builder macAddress(String var1);

        public Builder name(String var1);

        public Builder networkSettings(InputDeviceNetworkSettings var1);

        default public Builder networkSettings(Consumer<InputDeviceNetworkSettings.Builder> networkSettings) {
            return this.networkSettings((InputDeviceNetworkSettings)((InputDeviceNetworkSettings.Builder)InputDeviceNetworkSettings.builder().applyMutation(networkSettings)).build());
        }

        public Builder serialNumber(String var1);

        public Builder type(String var1);

        public Builder type(InputDeviceType var1);

        public Builder uhdDeviceSettings(InputDeviceUhdSettings var1);

        default public Builder uhdDeviceSettings(Consumer<InputDeviceUhdSettings.Builder> uhdDeviceSettings) {
            return this.uhdDeviceSettings((InputDeviceUhdSettings)((InputDeviceUhdSettings.Builder)InputDeviceUhdSettings.builder().applyMutation(uhdDeviceSettings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder availabilityZone(String var1);

        public Builder medialiveInputArns(Collection<String> var1);

        public Builder medialiveInputArns(String ... var1);

        public Builder outputType(String var1);

        public Builder outputType(InputDeviceOutputType var1);
    }
}

