/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.NodeConnectionState;
import software.amazon.awssdk.services.medialive.model.NodeInterfaceMapping;
import software.amazon.awssdk.services.medialive.model.NodeRole;
import software.amazon.awssdk.services.medialive.model.NodeState;
import software.amazon.awssdk.services.medialive.model.___listOfNodeInterfaceMappingCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeNodeSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeNodeSummary.getter(DescribeNodeSummary::arn)).setter(DescribeNodeSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> CHANNEL_PLACEMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelPlacementGroups").getter(DescribeNodeSummary.getter(DescribeNodeSummary::channelPlacementGroups)).setter(DescribeNodeSummary.setter(Builder::channelPlacementGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelPlacementGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(DescribeNodeSummary.getter(DescribeNodeSummary::clusterId)).setter(DescribeNodeSummary.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()}).build();
    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionState").getter(DescribeNodeSummary.getter(DescribeNodeSummary::connectionStateAsString)).setter(DescribeNodeSummary.setter(Builder::connectionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionState").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeNodeSummary.getter(DescribeNodeSummary::id)).setter(DescribeNodeSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DescribeNodeSummary.getter(DescribeNodeSummary::instanceArn)).setter(DescribeNodeSummary.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> MANAGED_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedInstanceId").getter(DescribeNodeSummary.getter(DescribeNodeSummary::managedInstanceId)).setter(DescribeNodeSummary.setter(Builder::managedInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedInstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeNodeSummary.getter(DescribeNodeSummary::name)).setter(DescribeNodeSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<NodeInterfaceMapping>> NODE_INTERFACE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeInterfaceMappings").getter(DescribeNodeSummary.getter(DescribeNodeSummary::nodeInterfaceMappings)).setter(DescribeNodeSummary.setter(Builder::nodeInterfaceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInterfaceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInterfaceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(DescribeNodeSummary.getter(DescribeNodeSummary::roleAsString)).setter(DescribeNodeSummary.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeNodeSummary.getter(DescribeNodeSummary::stateAsString)).setter(DescribeNodeSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_PLACEMENT_GROUPS_FIELD, CLUSTER_ID_FIELD, CONNECTION_STATE_FIELD, ID_FIELD, INSTANCE_ARN_FIELD, MANAGED_INSTANCE_ID_FIELD, NAME_FIELD, NODE_INTERFACE_MAPPINGS_FIELD, ROLE_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("channelPlacementGroups", CHANNEL_PLACEMENT_GROUPS_FIELD);
            this.put("clusterId", CLUSTER_ID_FIELD);
            this.put("connectionState", CONNECTION_STATE_FIELD);
            this.put("id", ID_FIELD);
            this.put("instanceArn", INSTANCE_ARN_FIELD);
            this.put("managedInstanceId", MANAGED_INSTANCE_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("nodeInterfaceMappings", NODE_INTERFACE_MAPPINGS_FIELD);
            this.put("role", ROLE_FIELD);
            this.put("state", STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> channelPlacementGroups;
    private final String clusterId;
    private final String connectionState;
    private final String id;
    private final String instanceArn;
    private final String managedInstanceId;
    private final String name;
    private final List<NodeInterfaceMapping> nodeInterfaceMappings;
    private final String role;
    private final String state;

    private DescribeNodeSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelPlacementGroups = builder.channelPlacementGroups;
        this.clusterId = builder.clusterId;
        this.connectionState = builder.connectionState;
        this.id = builder.id;
        this.instanceArn = builder.instanceArn;
        this.managedInstanceId = builder.managedInstanceId;
        this.name = builder.name;
        this.nodeInterfaceMappings = builder.nodeInterfaceMappings;
        this.role = builder.role;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasChannelPlacementGroups() {
        return this.channelPlacementGroups != null && !(this.channelPlacementGroups instanceof SdkAutoConstructList);
    }

    public final List<String> channelPlacementGroups() {
        return this.channelPlacementGroups;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final NodeConnectionState connectionState() {
        return NodeConnectionState.fromValue(this.connectionState);
    }

    public final String connectionStateAsString() {
        return this.connectionState;
    }

    public final String id() {
        return this.id;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String managedInstanceId() {
        return this.managedInstanceId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNodeInterfaceMappings() {
        return this.nodeInterfaceMappings != null && !(this.nodeInterfaceMappings instanceof SdkAutoConstructList);
    }

    public final List<NodeInterfaceMapping> nodeInterfaceMappings() {
        return this.nodeInterfaceMappings;
    }

    public final NodeRole role() {
        return NodeRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public final NodeState state() {
        return NodeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelPlacementGroups() ? this.channelPlacementGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeSummary)) {
            return false;
        }
        DescribeNodeSummary other = (DescribeNodeSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasChannelPlacementGroups() == other.hasChannelPlacementGroups() && Objects.equals(this.channelPlacementGroups(), other.channelPlacementGroups()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.connectionStateAsString(), other.connectionStateAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.managedInstanceId(), other.managedInstanceId()) && Objects.equals(this.name(), other.name()) && this.hasNodeInterfaceMappings() == other.hasNodeInterfaceMappings() && Objects.equals(this.nodeInterfaceMappings(), other.nodeInterfaceMappings()) && Objects.equals(this.roleAsString(), other.roleAsString()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNodeSummary").add("Arn", (Object)this.arn()).add("ChannelPlacementGroups", this.hasChannelPlacementGroups() ? this.channelPlacementGroups() : null).add("ClusterId", (Object)this.clusterId()).add("ConnectionState", (Object)this.connectionStateAsString()).add("Id", (Object)this.id()).add("InstanceArn", (Object)this.instanceArn()).add("ManagedInstanceId", (Object)this.managedInstanceId()).add("Name", (Object)this.name()).add("NodeInterfaceMappings", this.hasNodeInterfaceMappings() ? this.nodeInterfaceMappings() : null).add("Role", (Object)this.roleAsString()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelPlacementGroups": {
                return Optional.ofNullable(clazz.cast(this.channelPlacementGroups()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "ConnectionState": {
                return Optional.ofNullable(clazz.cast(this.connectionStateAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "ManagedInstanceId": {
                return Optional.ofNullable(clazz.cast(this.managedInstanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NodeInterfaceMappings": {
                return Optional.ofNullable(clazz.cast(this.nodeInterfaceMappings()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeSummary, T> g) {
        return obj -> g.apply((DescribeNodeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> channelPlacementGroups = DefaultSdkAutoConstructList.getInstance();
        private String clusterId;
        private String connectionState;
        private String id;
        private String instanceArn;
        private String managedInstanceId;
        private String name;
        private List<NodeInterfaceMapping> nodeInterfaceMappings = DefaultSdkAutoConstructList.getInstance();
        private String role;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeSummary model) {
            this.arn(model.arn);
            this.channelPlacementGroups(model.channelPlacementGroups);
            this.clusterId(model.clusterId);
            this.connectionState(model.connectionState);
            this.id(model.id);
            this.instanceArn(model.instanceArn);
            this.managedInstanceId(model.managedInstanceId);
            this.name(model.name);
            this.nodeInterfaceMappings(model.nodeInterfaceMappings);
            this.role(model.role);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannelPlacementGroups() {
            if (this.channelPlacementGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelPlacementGroups;
        }

        public final void setChannelPlacementGroups(Collection<String> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOf__stringCopier.copy(channelPlacementGroups);
        }

        @Override
        public final Builder channelPlacementGroups(Collection<String> channelPlacementGroups) {
            this.channelPlacementGroups = ___listOf__stringCopier.copy(channelPlacementGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelPlacementGroups(String ... channelPlacementGroups) {
            this.channelPlacementGroups(Arrays.asList(channelPlacementGroups));
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getConnectionState() {
            return this.connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(NodeConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getManagedInstanceId() {
            return this.managedInstanceId;
        }

        public final void setManagedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
        }

        @Override
        public final Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NodeInterfaceMapping.Builder> getNodeInterfaceMappings() {
            List<NodeInterfaceMapping.Builder> result = ___listOfNodeInterfaceMappingCopier.copyToBuilder(this.nodeInterfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInterfaceMappings(Collection<NodeInterfaceMapping.BuilderImpl> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copyFromBuilder(nodeInterfaceMappings);
        }

        @Override
        public final Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> nodeInterfaceMappings) {
            this.nodeInterfaceMappings = ___listOfNodeInterfaceMappingCopier.copy(nodeInterfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(NodeInterfaceMapping ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Arrays.asList(nodeInterfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder> ... nodeInterfaceMappings) {
            this.nodeInterfaceMappings(Stream.of(nodeInterfaceMappings).map(c -> (NodeInterfaceMapping)((NodeInterfaceMapping.Builder)NodeInterfaceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NodeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public DescribeNodeSummary build() {
            return new DescribeNodeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeNodeSummary> {
        public Builder arn(String var1);

        public Builder channelPlacementGroups(Collection<String> var1);

        public Builder channelPlacementGroups(String ... var1);

        public Builder clusterId(String var1);

        public Builder connectionState(String var1);

        public Builder connectionState(NodeConnectionState var1);

        public Builder id(String var1);

        public Builder instanceArn(String var1);

        public Builder managedInstanceId(String var1);

        public Builder name(String var1);

        public Builder nodeInterfaceMappings(Collection<NodeInterfaceMapping> var1);

        public Builder nodeInterfaceMappings(NodeInterfaceMapping ... var1);

        public Builder nodeInterfaceMappings(Consumer<NodeInterfaceMapping.Builder> ... var1);

        public Builder role(String var1);

        public Builder role(NodeRole var1);

        public Builder state(String var1);

        public Builder state(NodeState var1);
    }
}

