/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AccessibilityType;
import software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings;
import software.amazon.awssdk.services.medialive.model.DashRoleCaption;
import software.amazon.awssdk.services.medialive.model.DvbDashAccessibility;
import software.amazon.awssdk.services.medialive.model.___listOfDashRoleCaptionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionDescription> {
    private static final SdkField<String> ACCESSIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accessibility").getter(CaptionDescription.getter(CaptionDescription::accessibilityAsString)).setter(CaptionDescription.setter(Builder::accessibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessibility").build()}).build();
    private static final SdkField<String> CAPTION_SELECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionSelectorName").getter(CaptionDescription.getter(CaptionDescription::captionSelectorName)).setter(CaptionDescription.setter(Builder::captionSelectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectorName").build()}).build();
    private static final SdkField<CaptionDestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(CaptionDescription.getter(CaptionDescription::destinationSettings)).setter(CaptionDescription.setter(Builder::destinationSettings)).constructor(CaptionDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CaptionDescription.getter(CaptionDescription::languageCode)).setter(CaptionDescription.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageDescription").getter(CaptionDescription.getter(CaptionDescription::languageDescription)).setter(CaptionDescription.setter(Builder::languageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CaptionDescription.getter(CaptionDescription::name)).setter(CaptionDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CAPTION_DASH_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CaptionDashRoles").getter(CaptionDescription.getter(CaptionDescription::captionDashRolesAsStrings)).setter(CaptionDescription.setter(Builder::captionDashRolesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDashRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DVB_DASH_ACCESSIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DvbDashAccessibility").getter(CaptionDescription.getter(CaptionDescription::dvbDashAccessibilityAsString)).setter(CaptionDescription.setter(Builder::dvbDashAccessibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbDashAccessibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSIBILITY_FIELD, CAPTION_SELECTOR_NAME_FIELD, DESTINATION_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD, NAME_FIELD, CAPTION_DASH_ROLES_FIELD, DVB_DASH_ACCESSIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accessibility", ACCESSIBILITY_FIELD);
            this.put("captionSelectorName", CAPTION_SELECTOR_NAME_FIELD);
            this.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
            this.put("languageCode", LANGUAGE_CODE_FIELD);
            this.put("languageDescription", LANGUAGE_DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("captionDashRoles", CAPTION_DASH_ROLES_FIELD);
            this.put("dvbDashAccessibility", DVB_DASH_ACCESSIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String accessibility;
    private final String captionSelectorName;
    private final CaptionDestinationSettings destinationSettings;
    private final String languageCode;
    private final String languageDescription;
    private final String name;
    private final List<String> captionDashRoles;
    private final String dvbDashAccessibility;

    private CaptionDescription(BuilderImpl builder) {
        this.accessibility = builder.accessibility;
        this.captionSelectorName = builder.captionSelectorName;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
        this.name = builder.name;
        this.captionDashRoles = builder.captionDashRoles;
        this.dvbDashAccessibility = builder.dvbDashAccessibility;
    }

    public final AccessibilityType accessibility() {
        return AccessibilityType.fromValue(this.accessibility);
    }

    public final String accessibilityAsString() {
        return this.accessibility;
    }

    public final String captionSelectorName() {
        return this.captionSelectorName;
    }

    public final CaptionDestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final String languageCode() {
        return this.languageCode;
    }

    public final String languageDescription() {
        return this.languageDescription;
    }

    public final String name() {
        return this.name;
    }

    public final List<DashRoleCaption> captionDashRoles() {
        return ___listOfDashRoleCaptionCopier.copyStringToEnum(this.captionDashRoles);
    }

    public final boolean hasCaptionDashRoles() {
        return this.captionDashRoles != null && !(this.captionDashRoles instanceof SdkAutoConstructList);
    }

    public final List<String> captionDashRolesAsStrings() {
        return this.captionDashRoles;
    }

    public final DvbDashAccessibility dvbDashAccessibility() {
        return DvbDashAccessibility.fromValue(this.dvbDashAccessibility);
    }

    public final String dvbDashAccessibilityAsString() {
        return this.dvbDashAccessibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionDashRoles() ? this.captionDashRolesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbDashAccessibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription)obj;
        return Objects.equals(this.accessibilityAsString(), other.accessibilityAsString()) && Objects.equals(this.captionSelectorName(), other.captionSelectorName()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.languageDescription(), other.languageDescription()) && Objects.equals(this.name(), other.name()) && this.hasCaptionDashRoles() == other.hasCaptionDashRoles() && Objects.equals(this.captionDashRolesAsStrings(), other.captionDashRolesAsStrings()) && Objects.equals(this.dvbDashAccessibilityAsString(), other.dvbDashAccessibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CaptionDescription").add("Accessibility", (Object)this.accessibilityAsString()).add("CaptionSelectorName", (Object)this.captionSelectorName()).add("DestinationSettings", (Object)this.destinationSettings()).add("LanguageCode", (Object)this.languageCode()).add("LanguageDescription", (Object)this.languageDescription()).add("Name", (Object)this.name()).add("CaptionDashRoles", this.hasCaptionDashRoles() ? this.captionDashRolesAsStrings() : null).add("DvbDashAccessibility", (Object)this.dvbDashAccessibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accessibility": {
                return Optional.ofNullable(clazz.cast(this.accessibilityAsString()));
            }
            case "CaptionSelectorName": {
                return Optional.ofNullable(clazz.cast(this.captionSelectorName()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCode()));
            }
            case "LanguageDescription": {
                return Optional.ofNullable(clazz.cast(this.languageDescription()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CaptionDashRoles": {
                return Optional.ofNullable(clazz.cast(this.captionDashRolesAsStrings()));
            }
            case "DvbDashAccessibility": {
                return Optional.ofNullable(clazz.cast(this.dvbDashAccessibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CaptionDescription, T> g) {
        return obj -> g.apply((CaptionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessibility;
        private String captionSelectorName;
        private CaptionDestinationSettings destinationSettings;
        private String languageCode;
        private String languageDescription;
        private String name;
        private List<String> captionDashRoles = DefaultSdkAutoConstructList.getInstance();
        private String dvbDashAccessibility;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescription model) {
            this.accessibility(model.accessibility);
            this.captionSelectorName(model.captionSelectorName);
            this.destinationSettings(model.destinationSettings);
            this.languageCode(model.languageCode);
            this.languageDescription(model.languageDescription);
            this.name(model.name);
            this.captionDashRolesWithStrings(model.captionDashRoles);
            this.dvbDashAccessibility(model.dvbDashAccessibility);
        }

        public final String getAccessibility() {
            return this.accessibility;
        }

        public final void setAccessibility(String accessibility) {
            this.accessibility = accessibility;
        }

        @Override
        public final Builder accessibility(String accessibility) {
            this.accessibility = accessibility;
            return this;
        }

        @Override
        public final Builder accessibility(AccessibilityType accessibility) {
            this.accessibility(accessibility == null ? null : accessibility.toString());
            return this;
        }

        public final String getCaptionSelectorName() {
            return this.captionSelectorName;
        }

        public final void setCaptionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
        }

        @Override
        public final Builder captionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
            return this;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getLanguageDescription() {
            return this.languageDescription;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCaptionDashRoles() {
            if (this.captionDashRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.captionDashRoles;
        }

        public final void setCaptionDashRoles(Collection<String> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copy(captionDashRoles);
        }

        @Override
        public final Builder captionDashRolesWithStrings(Collection<String> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copy(captionDashRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDashRolesWithStrings(String ... captionDashRoles) {
            this.captionDashRolesWithStrings(Arrays.asList(captionDashRoles));
            return this;
        }

        @Override
        public final Builder captionDashRoles(Collection<DashRoleCaption> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copyEnumToString(captionDashRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDashRoles(DashRoleCaption ... captionDashRoles) {
            this.captionDashRoles(Arrays.asList(captionDashRoles));
            return this;
        }

        public final String getDvbDashAccessibility() {
            return this.dvbDashAccessibility;
        }

        public final void setDvbDashAccessibility(String dvbDashAccessibility) {
            this.dvbDashAccessibility = dvbDashAccessibility;
        }

        @Override
        public final Builder dvbDashAccessibility(String dvbDashAccessibility) {
            this.dvbDashAccessibility = dvbDashAccessibility;
            return this;
        }

        @Override
        public final Builder dvbDashAccessibility(DvbDashAccessibility dvbDashAccessibility) {
            this.dvbDashAccessibility(dvbDashAccessibility == null ? null : dvbDashAccessibility.toString());
            return this;
        }

        public CaptionDescription build() {
            return new CaptionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionDescription> {
        public Builder accessibility(String var1);

        public Builder accessibility(AccessibilityType var1);

        public Builder captionSelectorName(String var1);

        public Builder destinationSettings(CaptionDestinationSettings var1);

        default public Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((CaptionDestinationSettings)((CaptionDestinationSettings.Builder)CaptionDestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageDescription(String var1);

        public Builder name(String var1);

        public Builder captionDashRolesWithStrings(Collection<String> var1);

        public Builder captionDashRolesWithStrings(String ... var1);

        public Builder captionDashRoles(Collection<DashRoleCaption> var1);

        public Builder captionDashRoles(DashRoleCaption ... var1);

        public Builder dvbDashAccessibility(String var1);

        public Builder dvbDashAccessibility(DvbDashAccessibility var1);
    }
}

