/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MultiplexContainerSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiplexOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiplexOutputSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(MultiplexOutputSettings.getter(MultiplexOutputSettings::destination)).setter(MultiplexOutputSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<MultiplexContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerSettings").getter(MultiplexOutputSettings.getter(MultiplexOutputSettings::containerSettings)).setter(MultiplexOutputSettings.setter(Builder::containerSettings)).constructor(MultiplexContainerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, CONTAINER_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("destination", DESTINATION_FIELD);
            this.put("containerSettings", CONTAINER_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final OutputLocationRef destination;
    private final MultiplexContainerSettings containerSettings;

    private MultiplexOutputSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.containerSettings = builder.containerSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final MultiplexContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexOutputSettings)) {
            return false;
        }
        MultiplexOutputSettings other = (MultiplexOutputSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.containerSettings(), other.containerSettings());
    }

    public final String toString() {
        return ToString.builder((String)"MultiplexOutputSettings").add("Destination", (Object)this.destination()).add("ContainerSettings", (Object)this.containerSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "ContainerSettings": {
                return Optional.ofNullable(clazz.cast(this.containerSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexOutputSettings, T> g) {
        return obj -> g.apply((MultiplexOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private MultiplexContainerSettings containerSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexOutputSettings model) {
            this.destination(model.destination);
            this.containerSettings(model.containerSettings);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final MultiplexContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        public final void setContainerSettings(MultiplexContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        @Override
        public final Builder containerSettings(MultiplexContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public MultiplexOutputSettings build() {
            return new MultiplexOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiplexOutputSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder containerSettings(MultiplexContainerSettings var1);

        default public Builder containerSettings(Consumer<MultiplexContainerSettings.Builder> containerSettings) {
            return this.containerSettings((MultiplexContainerSettings)((MultiplexContainerSettings.Builder)MultiplexContainerSettings.builder().applyMutation(containerSettings)).build());
        }
    }
}

