/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit;
import software.amazon.awssdk.services.medialive.model.TimecodeBurninSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameCaptureSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameCaptureSettings> {
    private static final SdkField<Integer> CAPTURE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CaptureInterval").getter(FrameCaptureSettings.getter(FrameCaptureSettings::captureInterval)).setter(FrameCaptureSettings.setter(Builder::captureInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureInterval").build()}).build();
    private static final SdkField<String> CAPTURE_INTERVAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptureIntervalUnits").getter(FrameCaptureSettings.getter(FrameCaptureSettings::captureIntervalUnitsAsString)).setter(FrameCaptureSettings.setter(Builder::captureIntervalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureIntervalUnits").build()}).build();
    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings").getter(FrameCaptureSettings.getter(FrameCaptureSettings::timecodeBurninSettings)).setter(FrameCaptureSettings.setter(Builder::timecodeBurninSettings)).constructor(TimecodeBurninSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_INTERVAL_FIELD, CAPTURE_INTERVAL_UNITS_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("captureInterval", CAPTURE_INTERVAL_FIELD);
            this.put("captureIntervalUnits", CAPTURE_INTERVAL_UNITS_FIELD);
            this.put("timecodeBurninSettings", TIMECODE_BURNIN_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer captureInterval;
    private final String captureIntervalUnits;
    private final TimecodeBurninSettings timecodeBurninSettings;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.captureInterval = builder.captureInterval;
        this.captureIntervalUnits = builder.captureIntervalUnits;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
    }

    public final Integer captureInterval() {
        return this.captureInterval;
    }

    public final FrameCaptureIntervalUnit captureIntervalUnits() {
        return FrameCaptureIntervalUnit.fromValue(this.captureIntervalUnits);
    }

    public final String captureIntervalUnitsAsString() {
        return this.captureIntervalUnits;
    }

    public final TimecodeBurninSettings timecodeBurninSettings() {
        return this.timecodeBurninSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captureInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureIntervalUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeBurninSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings)obj;
        return Objects.equals(this.captureInterval(), other.captureInterval()) && Objects.equals(this.captureIntervalUnitsAsString(), other.captureIntervalUnitsAsString()) && Objects.equals(this.timecodeBurninSettings(), other.timecodeBurninSettings());
    }

    public final String toString() {
        return ToString.builder((String)"FrameCaptureSettings").add("CaptureInterval", (Object)this.captureInterval()).add("CaptureIntervalUnits", (Object)this.captureIntervalUnitsAsString()).add("TimecodeBurninSettings", (Object)this.timecodeBurninSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptureInterval": {
                return Optional.ofNullable(clazz.cast(this.captureInterval()));
            }
            case "CaptureIntervalUnits": {
                return Optional.ofNullable(clazz.cast(this.captureIntervalUnitsAsString()));
            }
            case "TimecodeBurninSettings": {
                return Optional.ofNullable(clazz.cast(this.timecodeBurninSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureSettings, T> g) {
        return obj -> g.apply((FrameCaptureSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer captureInterval;
        private String captureIntervalUnits;
        private TimecodeBurninSettings timecodeBurninSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            this.captureInterval(model.captureInterval);
            this.captureIntervalUnits(model.captureIntervalUnits);
            this.timecodeBurninSettings(model.timecodeBurninSettings);
        }

        public final Integer getCaptureInterval() {
            return this.captureInterval;
        }

        public final void setCaptureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
        }

        @Override
        public final Builder captureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
            return this;
        }

        public final String getCaptureIntervalUnits() {
            return this.captureIntervalUnits;
        }

        public final void setCaptureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
        }

        @Override
        public final Builder captureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
            return this;
        }

        @Override
        public final Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits) {
            this.captureIntervalUnits(captureIntervalUnits == null ? null : captureIntervalUnits.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return this.timecodeBurninSettings != null ? this.timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameCaptureSettings> {
        public Builder captureInterval(Integer var1);

        public Builder captureIntervalUnits(String var1);

        public Builder captureIntervalUnits(FrameCaptureIntervalUnit var1);

        public Builder timecodeBurninSettings(TimecodeBurninSettings var1);

        default public Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return this.timecodeBurninSettings((TimecodeBurninSettings)((TimecodeBurninSettings.Builder)TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings)).build());
        }
    }
}

