/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.ClusterNetworkSettings;
import software.amazon.awssdk.services.medialive.model.ClusterState;
import software.amazon.awssdk.services.medialive.model.ClusterType;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteClusterResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DeleteClusterResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeleteClusterResponse.getter(DeleteClusterResponse::arn)).setter(DeleteClusterResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelIds").getter(DeleteClusterResponse.getter(DeleteClusterResponse::channelIds)).setter(DeleteClusterResponse.setter(Builder::channelIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(DeleteClusterResponse.getter(DeleteClusterResponse::clusterTypeAsString)).setter(DeleteClusterResponse.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DeleteClusterResponse.getter(DeleteClusterResponse::id)).setter(DeleteClusterResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRoleArn").getter(DeleteClusterResponse.getter(DeleteClusterResponse::instanceRoleArn)).setter(DeleteClusterResponse.setter(Builder::instanceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceRoleArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DeleteClusterResponse.getter(DeleteClusterResponse::name)).setter(DeleteClusterResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ClusterNetworkSettings> NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkSettings").getter(DeleteClusterResponse.getter(DeleteClusterResponse::networkSettings)).setter(DeleteClusterResponse.setter(Builder::networkSettings)).constructor(ClusterNetworkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DeleteClusterResponse.getter(DeleteClusterResponse::stateAsString)).setter(DeleteClusterResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_IDS_FIELD, CLUSTER_TYPE_FIELD, ID_FIELD, INSTANCE_ROLE_ARN_FIELD, NAME_FIELD, NETWORK_SETTINGS_FIELD, STATE_FIELD));
    private final String arn;
    private final List<String> channelIds;
    private final String clusterType;
    private final String id;
    private final String instanceRoleArn;
    private final String name;
    private final ClusterNetworkSettings networkSettings;
    private final String state;

    private DeleteClusterResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelIds = builder.channelIds;
        this.clusterType = builder.clusterType;
        this.id = builder.id;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasChannelIds() {
        return this.channelIds != null && !(this.channelIds instanceof SdkAutoConstructList);
    }

    public final List<String> channelIds() {
        return this.channelIds;
    }

    public final ClusterType clusterType() {
        return ClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final String id() {
        return this.id;
    }

    public final String instanceRoleArn() {
        return this.instanceRoleArn;
    }

    public final String name() {
        return this.name;
    }

    public final ClusterNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    public final ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelIds() ? this.channelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterResponse)) {
            return false;
        }
        DeleteClusterResponse other = (DeleteClusterResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasChannelIds() == other.hasChannelIds() && Objects.equals(this.channelIds(), other.channelIds()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkSettings(), other.networkSettings()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteClusterResponse").add("Arn", (Object)this.arn()).add("ChannelIds", this.hasChannelIds() ? this.channelIds() : null).add("ClusterType", (Object)this.clusterTypeAsString()).add("Id", (Object)this.id()).add("InstanceRoleArn", (Object)this.instanceRoleArn()).add("Name", (Object)this.name()).add("NetworkSettings", (Object)this.networkSettings()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelIds": {
                return Optional.ofNullable(clazz.cast(this.channelIds()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InstanceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NetworkSettings": {
                return Optional.ofNullable(clazz.cast(this.networkSettings()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterResponse, T> g) {
        return obj -> g.apply((DeleteClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();
        private String clusterType;
        private String id;
        private String instanceRoleArn;
        private String name;
        private ClusterNetworkSettings networkSettings;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterResponse model) {
            super(model);
            this.arn(model.arn);
            this.channelIds(model.channelIds);
            this.clusterType(model.clusterType);
            this.id(model.id);
            this.instanceRoleArn(model.instanceRoleArn);
            this.name(model.name);
            this.networkSettings(model.networkSettings);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannelIds() {
            if (this.channelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelIds;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String ... channelIds) {
            this.channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ClusterNetworkSettings.Builder getNetworkSettings() {
            return this.networkSettings != null ? this.networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(ClusterNetworkSettings.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(ClusterNetworkSettings networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DeleteClusterResponse build() {
            return new DeleteClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteClusterResponse> {
        public Builder arn(String var1);

        public Builder channelIds(Collection<String> var1);

        public Builder channelIds(String ... var1);

        public Builder clusterType(String var1);

        public Builder clusterType(ClusterType var1);

        public Builder id(String var1);

        public Builder instanceRoleArn(String var1);

        public Builder name(String var1);

        public Builder networkSettings(ClusterNetworkSettings var1);

        default public Builder networkSettings(Consumer<ClusterNetworkSettings.Builder> networkSettings) {
            return this.networkSettings((ClusterNetworkSettings)((ClusterNetworkSettings.Builder)ClusterNetworkSettings.builder().applyMutation(networkSettings)).build());
        }

        public Builder state(String var1);

        public Builder state(ClusterState var1);
    }
}

