/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateComparisonOperator;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateStatistic;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateTargetResourceType;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateTreatMissingData;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCloudWatchAlarmTemplateResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, GetCloudWatchAlarmTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::arn)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::comparisonOperatorAsString)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::createdAt)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DatapointsToAlarm").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::datapointsToAlarm)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::description)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::evaluationPeriods)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::groupId)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::id)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::metricName)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::modifiedAt)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::name)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::period)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Statistic").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::statisticAsString)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::tags)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetResourceType").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::targetResourceTypeAsString)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::targetResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::threshold)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatMissingData").getter(GetCloudWatchAlarmTemplateResponse.getter(GetCloudWatchAlarmTemplateResponse::treatMissingDataAsString)).setter(GetCloudWatchAlarmTemplateResponse.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COMPARISON_OPERATOR_FIELD, CREATED_AT_FIELD, DATAPOINTS_TO_ALARM_FIELD, DESCRIPTION_FIELD, EVALUATION_PERIODS_FIELD, GROUP_ID_FIELD, ID_FIELD, METRIC_NAME_FIELD, MODIFIED_AT_FIELD, NAME_FIELD, PERIOD_FIELD, STATISTIC_FIELD, TAGS_FIELD, TARGET_RESOURCE_TYPE_FIELD, THRESHOLD_FIELD, TREAT_MISSING_DATA_FIELD));
    private final String arn;
    private final String comparisonOperator;
    private final Instant createdAt;
    private final Integer datapointsToAlarm;
    private final String description;
    private final Integer evaluationPeriods;
    private final String groupId;
    private final String id;
    private final String metricName;
    private final Instant modifiedAt;
    private final String name;
    private final Integer period;
    private final String statistic;
    private final Map<String, String> tags;
    private final String targetResourceType;
    private final Double threshold;
    private final String treatMissingData;

    private GetCloudWatchAlarmTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.comparisonOperator = builder.comparisonOperator;
        this.createdAt = builder.createdAt;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.description = builder.description;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.groupId = builder.groupId;
        this.id = builder.id;
        this.metricName = builder.metricName;
        this.modifiedAt = builder.modifiedAt;
        this.name = builder.name;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.tags = builder.tags;
        this.targetResourceType = builder.targetResourceType;
        this.threshold = builder.threshold;
        this.treatMissingData = builder.treatMissingData;
    }

    public final String arn() {
        return this.arn;
    }

    public final CloudWatchAlarmTemplateComparisonOperator comparisonOperator() {
        return CloudWatchAlarmTemplateComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public final String description() {
        return this.description;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String id() {
        return this.id;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final String name() {
        return this.name;
    }

    public final Integer period() {
        return this.period;
    }

    public final CloudWatchAlarmTemplateStatistic statistic() {
        return CloudWatchAlarmTemplateStatistic.fromValue(this.statistic);
    }

    public final String statisticAsString() {
        return this.statistic;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final CloudWatchAlarmTemplateTargetResourceType targetResourceType() {
        return CloudWatchAlarmTemplateTargetResourceType.fromValue(this.targetResourceType);
    }

    public final String targetResourceTypeAsString() {
        return this.targetResourceType;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final CloudWatchAlarmTemplateTreatMissingData treatMissingData() {
        return CloudWatchAlarmTemplateTreatMissingData.fromValue(this.treatMissingData);
    }

    public final String treatMissingDataAsString() {
        return this.treatMissingData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingDataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudWatchAlarmTemplateResponse)) {
            return false;
        }
        GetCloudWatchAlarmTemplateResponse other = (GetCloudWatchAlarmTemplateResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.targetResourceTypeAsString(), other.targetResourceTypeAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.treatMissingDataAsString(), other.treatMissingDataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetCloudWatchAlarmTemplateResponse").add("Arn", (Object)this.arn()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("CreatedAt", (Object)this.createdAt()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("Description", (Object)this.description()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("GroupId", (Object)this.groupId()).add("Id", (Object)this.id()).add("MetricName", (Object)this.metricName()).add("ModifiedAt", (Object)this.modifiedAt()).add("Name", (Object)this.name()).add("Period", (Object)this.period()).add("Statistic", (Object)this.statisticAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("TargetResourceType", (Object)this.targetResourceTypeAsString()).add("Threshold", (Object)this.threshold()).add("TreatMissingData", (Object)this.treatMissingDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DatapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TargetResourceType": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypeAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "TreatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingDataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCloudWatchAlarmTemplateResponse, T> g) {
        return obj -> g.apply((GetCloudWatchAlarmTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String comparisonOperator;
        private Instant createdAt;
        private Integer datapointsToAlarm;
        private String description;
        private Integer evaluationPeriods;
        private String groupId;
        private String id;
        private String metricName;
        private Instant modifiedAt;
        private String name;
        private Integer period;
        private String statistic;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String targetResourceType;
        private Double threshold;
        private String treatMissingData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudWatchAlarmTemplateResponse model) {
            super(model);
            this.arn(model.arn);
            this.comparisonOperator(model.comparisonOperator);
            this.createdAt(model.createdAt);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.description(model.description);
            this.evaluationPeriods(model.evaluationPeriods);
            this.groupId(model.groupId);
            this.id(model.id);
            this.metricName(model.metricName);
            this.modifiedAt(model.modifiedAt);
            this.name(model.name);
            this.period(model.period);
            this.statistic(model.statistic);
            this.tags(model.tags);
            this.targetResourceType(model.targetResourceType);
            this.threshold(model.threshold);
            this.treatMissingData(model.treatMissingData);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(CloudWatchAlarmTemplateStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetResourceType() {
            return this.targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        @Override
        public GetCloudWatchAlarmTemplateResponse build() {
            return new GetCloudWatchAlarmTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCloudWatchAlarmTemplateResponse> {
        public Builder arn(String var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator var1);

        public Builder createdAt(Instant var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder description(String var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder groupId(String var1);

        public Builder id(String var1);

        public Builder metricName(String var1);

        public Builder modifiedAt(Instant var1);

        public Builder name(String var1);

        public Builder period(Integer var1);

        public Builder statistic(String var1);

        public Builder statistic(CloudWatchAlarmTemplateStatistic var1);

        public Builder tags(Map<String, String> var1);

        public Builder targetResourceType(String var1);

        public Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType var1);

        public Builder threshold(Double var1);

        public Builder treatMissingData(String var1);

        public Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData var1);
    }
}

