/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.IpPool;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.NetworkState;
import software.amazon.awssdk.services.medialive.model.Route;
import software.amazon.awssdk.services.medialive.model.___listOfIpPoolCopier;
import software.amazon.awssdk.services.medialive.model.___listOfRouteCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeNetworkResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::arn)).setter(DescribeNetworkResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedClusterIds").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::associatedClusterIds)).setter(DescribeNetworkResponse.setter(Builder::associatedClusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedClusterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::id)).setter(DescribeNetworkResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<IpPool>> IP_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPools").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::ipPools)).setter(DescribeNetworkResponse.setter(Builder::ipPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPool::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::name)).setter(DescribeNetworkResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::routes)).setter(DescribeNetworkResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeNetworkResponse.getter(DescribeNetworkResponse::stateAsString)).setter(DescribeNetworkResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSOCIATED_CLUSTER_IDS_FIELD, ID_FIELD, IP_POOLS_FIELD, NAME_FIELD, ROUTES_FIELD, STATE_FIELD));
    private final String arn;
    private final List<String> associatedClusterIds;
    private final String id;
    private final List<IpPool> ipPools;
    private final String name;
    private final List<Route> routes;
    private final String state;

    private DescribeNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatedClusterIds = builder.associatedClusterIds;
        this.id = builder.id;
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.routes = builder.routes;
        this.state = builder.state;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAssociatedClusterIds() {
        return this.associatedClusterIds != null && !(this.associatedClusterIds instanceof SdkAutoConstructList);
    }

    public final List<String> associatedClusterIds() {
        return this.associatedClusterIds;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasIpPools() {
        return this.ipPools != null && !(this.ipPools instanceof SdkAutoConstructList);
    }

    public final List<IpPool> ipPools() {
        return this.ipPools;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<Route> routes() {
        return this.routes;
    }

    public final NetworkState state() {
        return NetworkState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedClusterIds() ? this.associatedClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPools() ? this.ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkResponse)) {
            return false;
        }
        DescribeNetworkResponse other = (DescribeNetworkResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasAssociatedClusterIds() == other.hasAssociatedClusterIds() && Objects.equals(this.associatedClusterIds(), other.associatedClusterIds()) && Objects.equals(this.id(), other.id()) && this.hasIpPools() == other.hasIpPools() && Objects.equals(this.ipPools(), other.ipPools()) && Objects.equals(this.name(), other.name()) && this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkResponse").add("Arn", (Object)this.arn()).add("AssociatedClusterIds", this.hasAssociatedClusterIds() ? this.associatedClusterIds() : null).add("Id", (Object)this.id()).add("IpPools", this.hasIpPools() ? this.ipPools() : null).add("Name", (Object)this.name()).add("Routes", this.hasRoutes() ? this.routes() : null).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssociatedClusterIds": {
                return Optional.ofNullable(clazz.cast(this.associatedClusterIds()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IpPools": {
                return Optional.ofNullable(clazz.cast(this.ipPools()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkResponse, T> g) {
        return obj -> g.apply((DescribeNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> associatedClusterIds = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private List<IpPool> ipPools = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkResponse model) {
            super(model);
            this.arn(model.arn);
            this.associatedClusterIds(model.associatedClusterIds);
            this.id(model.id);
            this.ipPools(model.ipPools);
            this.name(model.name);
            this.routes(model.routes);
            this.state(model.state);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAssociatedClusterIds() {
            if (this.associatedClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedClusterIds;
        }

        public final void setAssociatedClusterIds(Collection<String> associatedClusterIds) {
            this.associatedClusterIds = ___listOf__stringCopier.copy(associatedClusterIds);
        }

        @Override
        public final Builder associatedClusterIds(Collection<String> associatedClusterIds) {
            this.associatedClusterIds = ___listOf__stringCopier.copy(associatedClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusterIds(String ... associatedClusterIds) {
            this.associatedClusterIds(Arrays.asList(associatedClusterIds));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<IpPool.Builder> getIpPools() {
            List<IpPool.Builder> result = ___listOfIpPoolCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPool.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPool> ipPools) {
            this.ipPools = ___listOfIpPoolCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPool ... ipPools) {
            this.ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPool.Builder> ... ipPools) {
            this.ipPools(Stream.of(ipPools).map(c -> (IpPool)((IpPool.Builder)IpPool.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = ___listOfRouteCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = ___listOfRouteCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = ___listOfRouteCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DescribeNetworkResponse build() {
            return new DescribeNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkResponse> {
        public Builder arn(String var1);

        public Builder associatedClusterIds(Collection<String> var1);

        public Builder associatedClusterIds(String ... var1);

        public Builder id(String var1);

        public Builder ipPools(Collection<IpPool> var1);

        public Builder ipPools(IpPool ... var1);

        public Builder ipPools(Consumer<IpPool.Builder> ... var1);

        public Builder name(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder routes(Consumer<Route.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(NetworkState var1);
    }
}

