/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputNetworkLocation {
    AWS("AWS"),
    ON_PREMISE("ON_PREMISE"),
    ON_PREMISES("ON_PREMISES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputNetworkLocation> VALUE_MAP;
    private final String value;

    private InputNetworkLocation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputNetworkLocation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputNetworkLocation> knownValues() {
        EnumSet<InputNetworkLocation> knownValues = EnumSet.allOf(InputNetworkLocation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputNetworkLocation.class, InputNetworkLocation::toString);
    }
}

