/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.SignalMapSummary;

public class ListSignalMapsIterable
implements SdkIterable<ListSignalMapsResponse> {
    private final MediaLiveClient client;
    private final ListSignalMapsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSignalMapsIterable(MediaLiveClient client, ListSignalMapsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSignalMapsResponseFetcher();
    }

    public Iterator<ListSignalMapsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SignalMapSummary> signalMaps() {
        Function<ListSignalMapsResponse, Iterator> getIterator = response -> {
            if (response != null && response.signalMaps() != null) {
                return response.signalMaps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSignalMapsResponseFetcher
    implements SyncPageFetcher<ListSignalMapsResponse> {
        private ListSignalMapsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalMapsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSignalMapsResponse nextPage(ListSignalMapsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalMapsIterable.this.client.listSignalMaps(ListSignalMapsIterable.this.firstRequest);
            }
            return ListSignalMapsIterable.this.client.listSignalMaps((ListSignalMapsRequest)((Object)ListSignalMapsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

