/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.CmafIngestSegmentLengthUnits;
import software.amazon.awssdk.services.medialive.model.CmafNielsenId3Behavior;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.Scte35Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafIngestGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafIngestGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::destination)).setter(CmafIngestGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenId3Behavior").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::nielsenId3BehaviorAsString)).setter(CmafIngestGroupSettings.setter(Builder::nielsenId3Behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build()}).build();
    private static final SdkField<String> SCTE35_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Type").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::scte35TypeAsString)).setter(CmafIngestGroupSettings.setter(Builder::scte35Type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Type").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::segmentLength)).setter(CmafIngestGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_LENGTH_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentLengthUnits").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::segmentLengthUnitsAsString)).setter(CmafIngestGroupSettings.setter(Builder::segmentLengthUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthUnits").build()}).build();
    private static final SdkField<Integer> SEND_DELAY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SendDelayMs").getter(CmafIngestGroupSettings.getter(CmafIngestGroupSettings::sendDelayMs)).setter(CmafIngestGroupSettings.setter(Builder::sendDelayMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sendDelayMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, NIELSEN_ID3_BEHAVIOR_FIELD, SCTE35_TYPE_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_UNITS_FIELD, SEND_DELAY_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final OutputLocationRef destination;
    private final String nielsenId3Behavior;
    private final String scte35Type;
    private final Integer segmentLength;
    private final String segmentLengthUnits;
    private final Integer sendDelayMs;

    private CmafIngestGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.scte35Type = builder.scte35Type;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthUnits = builder.segmentLengthUnits;
        this.sendDelayMs = builder.sendDelayMs;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final CmafNielsenId3Behavior nielsenId3Behavior() {
        return CmafNielsenId3Behavior.fromValue(this.nielsenId3Behavior);
    }

    public final String nielsenId3BehaviorAsString() {
        return this.nielsenId3Behavior;
    }

    public final Scte35Type scte35Type() {
        return Scte35Type.fromValue(this.scte35Type);
    }

    public final String scte35TypeAsString() {
        return this.scte35Type;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final CmafIngestSegmentLengthUnits segmentLengthUnits() {
        return CmafIngestSegmentLengthUnits.fromValue(this.segmentLengthUnits);
    }

    public final String segmentLengthUnitsAsString() {
        return this.segmentLengthUnits;
    }

    public final Integer sendDelayMs() {
        return this.sendDelayMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35TypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLengthUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendDelayMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafIngestGroupSettings)) {
            return false;
        }
        CmafIngestGroupSettings other = (CmafIngestGroupSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString()) && Objects.equals(this.scte35TypeAsString(), other.scte35TypeAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentLengthUnitsAsString(), other.segmentLengthUnitsAsString()) && Objects.equals(this.sendDelayMs(), other.sendDelayMs());
    }

    public final String toString() {
        return ToString.builder((String)"CmafIngestGroupSettings").add("Destination", (Object)this.destination()).add("NielsenId3Behavior", (Object)this.nielsenId3BehaviorAsString()).add("Scte35Type", (Object)this.scte35TypeAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentLengthUnits", (Object)this.segmentLengthUnitsAsString()).add("SendDelayMs", (Object)this.sendDelayMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "NielsenId3Behavior": {
                return Optional.ofNullable(clazz.cast(this.nielsenId3BehaviorAsString()));
            }
            case "Scte35Type": {
                return Optional.ofNullable(clazz.cast(this.scte35TypeAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentLengthUnits": {
                return Optional.ofNullable(clazz.cast(this.segmentLengthUnitsAsString()));
            }
            case "SendDelayMs": {
                return Optional.ofNullable(clazz.cast(this.sendDelayMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafIngestGroupSettings, T> g) {
        return obj -> g.apply((CmafIngestGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private String nielsenId3Behavior;
        private String scte35Type;
        private Integer segmentLength;
        private String segmentLengthUnits;
        private Integer sendDelayMs;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafIngestGroupSettings model) {
            this.destination(model.destination);
            this.nielsenId3Behavior(model.nielsenId3Behavior);
            this.scte35Type(model.scte35Type);
            this.segmentLength(model.segmentLength);
            this.segmentLengthUnits(model.segmentLengthUnits);
            this.sendDelayMs(model.sendDelayMs);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final String getNielsenId3Behavior() {
            return this.nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(CmafNielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final String getScte35Type() {
            return this.scte35Type;
        }

        public final void setScte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
        }

        @Override
        public final Builder scte35Type(String scte35Type) {
            this.scte35Type = scte35Type;
            return this;
        }

        @Override
        public final Builder scte35Type(Scte35Type scte35Type) {
            this.scte35Type(scte35Type == null ? null : scte35Type.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthUnits() {
            return this.segmentLengthUnits;
        }

        public final void setSegmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
        }

        @Override
        public final Builder segmentLengthUnits(String segmentLengthUnits) {
            this.segmentLengthUnits = segmentLengthUnits;
            return this;
        }

        @Override
        public final Builder segmentLengthUnits(CmafIngestSegmentLengthUnits segmentLengthUnits) {
            this.segmentLengthUnits(segmentLengthUnits == null ? null : segmentLengthUnits.toString());
            return this;
        }

        public final Integer getSendDelayMs() {
            return this.sendDelayMs;
        }

        public final void setSendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
        }

        @Override
        public final Builder sendDelayMs(Integer sendDelayMs) {
            this.sendDelayMs = sendDelayMs;
            return this;
        }

        public CmafIngestGroupSettings build() {
            return new CmafIngestGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafIngestGroupSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder nielsenId3Behavior(String var1);

        public Builder nielsenId3Behavior(CmafNielsenId3Behavior var1);

        public Builder scte35Type(String var1);

        public Builder scte35Type(Scte35Type var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentLengthUnits(String var1);

        public Builder segmentLengthUnits(CmafIngestSegmentLengthUnits var1);

        public Builder sendDelayMs(Integer var1);
    }
}

