/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.SignalMapMonitorDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitorDeployment> {
    private static final SdkField<String> DETAILS_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailsUri").getter(MonitorDeployment.getter(MonitorDeployment::detailsUri)).setter(MonitorDeployment.setter(Builder::detailsUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailsUri").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(MonitorDeployment.getter(MonitorDeployment::errorMessage)).setter(MonitorDeployment.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MonitorDeployment.getter(MonitorDeployment::statusAsString)).setter(MonitorDeployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_URI_FIELD, ERROR_MESSAGE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detailsUri;
    private final String errorMessage;
    private final String status;

    private MonitorDeployment(BuilderImpl builder) {
        this.detailsUri = builder.detailsUri;
        this.errorMessage = builder.errorMessage;
        this.status = builder.status;
    }

    public final String detailsUri() {
        return this.detailsUri;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final SignalMapMonitorDeploymentStatus status() {
        return SignalMapMonitorDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detailsUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorDeployment)) {
            return false;
        }
        MonitorDeployment other = (MonitorDeployment)obj;
        return Objects.equals(this.detailsUri(), other.detailsUri()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorDeployment").add("DetailsUri", (Object)this.detailsUri()).add("ErrorMessage", (Object)this.errorMessage()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetailsUri": {
                return Optional.ofNullable(clazz.cast(this.detailsUri()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitorDeployment, T> g) {
        return obj -> g.apply((MonitorDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detailsUri;
        private String errorMessage;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorDeployment model) {
            this.detailsUri(model.detailsUri);
            this.errorMessage(model.errorMessage);
            this.status(model.status);
        }

        public final String getDetailsUri() {
            return this.detailsUri;
        }

        public final void setDetailsUri(String detailsUri) {
            this.detailsUri = detailsUri;
        }

        @Override
        public final Builder detailsUri(String detailsUri) {
            this.detailsUri = detailsUri;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SignalMapMonitorDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public MonitorDeployment build() {
            return new MonitorDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitorDeployment> {
        public Builder detailsUri(String var1);

        public Builder errorMessage(String var1);

        public Builder status(String var1);

        public Builder status(SignalMapMonitorDeploymentStatus var1);
    }
}

