/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;

public class ListCloudWatchAlarmTemplatesIterable
implements SdkIterable<ListCloudWatchAlarmTemplatesResponse> {
    private final MediaLiveClient client;
    private final ListCloudWatchAlarmTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudWatchAlarmTemplatesIterable(MediaLiveClient client, ListCloudWatchAlarmTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudWatchAlarmTemplatesResponseFetcher();
    }

    public Iterator<ListCloudWatchAlarmTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates() {
        Function<ListCloudWatchAlarmTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudWatchAlarmTemplates() != null) {
                return response.cloudWatchAlarmTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudWatchAlarmTemplatesResponseFetcher
    implements SyncPageFetcher<ListCloudWatchAlarmTemplatesResponse> {
        private ListCloudWatchAlarmTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudWatchAlarmTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudWatchAlarmTemplatesResponse nextPage(ListCloudWatchAlarmTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCloudWatchAlarmTemplatesIterable.this.client.listCloudWatchAlarmTemplates(ListCloudWatchAlarmTemplatesIterable.this.firstRequest);
            }
            return ListCloudWatchAlarmTemplatesIterable.this.client.listCloudWatchAlarmTemplates((ListCloudWatchAlarmTemplatesRequest)((Object)ListCloudWatchAlarmTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

