/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.TimecodeConfigSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimecodeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimecodeConfig> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(TimecodeConfig.getter(TimecodeConfig::sourceAsString)).setter(TimecodeConfig.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Integer> SYNC_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SyncThreshold").getter(TimecodeConfig.getter(TimecodeConfig::syncThreshold)).setter(TimecodeConfig.setter(Builder::syncThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, SYNC_THRESHOLD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String source;
    private final Integer syncThreshold;

    private TimecodeConfig(BuilderImpl builder) {
        this.source = builder.source;
        this.syncThreshold = builder.syncThreshold;
    }

    public final TimecodeConfigSource source() {
        return TimecodeConfigSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final Integer syncThreshold() {
        return this.syncThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig)obj;
        return Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.syncThreshold(), other.syncThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"TimecodeConfig").add("Source", (Object)this.sourceAsString()).add("SyncThreshold", (Object)this.syncThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "SyncThreshold": {
                return Optional.ofNullable(clazz.cast(this.syncThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimecodeConfig, T> g) {
        return obj -> g.apply((TimecodeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private Integer syncThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            this.source(model.source);
            this.syncThreshold(model.syncThreshold);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeConfigSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Integer getSyncThreshold() {
            return this.syncThreshold;
        }

        public final void setSyncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
        }

        @Override
        public final Builder syncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
            return this;
        }

        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimecodeConfig> {
        public Builder source(String var1);

        public Builder source(TimecodeConfigSource var1);

        public Builder syncThreshold(Integer var1);
    }
}

