/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.Offering;

public class ListOfferingsPublisher
implements SdkPublisher<ListOfferingsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOfferingsPublisher(MediaLiveAsyncClient client, ListOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOfferingsPublisher(MediaLiveAsyncClient client, ListOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Offering> offerings() {
        Function<ListOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.offerings() != null) {
                return response.offerings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOfferingsResponseFetcher
    implements AsyncPageFetcher<ListOfferingsResponse> {
        private ListOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOfferingsResponse> nextPage(ListOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListOfferingsPublisher.this.client.listOfferings(ListOfferingsPublisher.this.firstRequest);
            }
            return ListOfferingsPublisher.this.client.listOfferings((ListOfferingsRequest)((Object)ListOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

