/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.ChannelPipelineIdToRestart;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOfChannelPipelineIdToRestartCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestartChannelPipelinesRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, RestartChannelPipelinesRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(RestartChannelPipelinesRequest.getter(RestartChannelPipelinesRequest::channelId)).setter(RestartChannelPipelinesRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<List<String>> PIPELINE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineIds").getter(RestartChannelPipelinesRequest.getter(RestartChannelPipelinesRequest::pipelineIdsAsStrings)).setter(RestartChannelPipelinesRequest.setter(Builder::pipelineIdsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, PIPELINE_IDS_FIELD));
    private final String channelId;
    private final List<String> pipelineIds;

    private RestartChannelPipelinesRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.pipelineIds = builder.pipelineIds;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final List<ChannelPipelineIdToRestart> pipelineIds() {
        return ___listOfChannelPipelineIdToRestartCopier.copyStringToEnum(this.pipelineIds);
    }

    public final boolean hasPipelineIds() {
        return this.pipelineIds != null && !(this.pipelineIds instanceof SdkAutoConstructList);
    }

    public final List<String> pipelineIdsAsStrings() {
        return this.pipelineIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineIds() ? this.pipelineIdsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestartChannelPipelinesRequest)) {
            return false;
        }
        RestartChannelPipelinesRequest other = (RestartChannelPipelinesRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && this.hasPipelineIds() == other.hasPipelineIds() && Objects.equals(this.pipelineIdsAsStrings(), other.pipelineIdsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RestartChannelPipelinesRequest").add("ChannelId", (Object)this.channelId()).add("PipelineIds", this.hasPipelineIds() ? this.pipelineIdsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "PipelineIds": {
                return Optional.ofNullable(clazz.cast(this.pipelineIdsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestartChannelPipelinesRequest, T> g) {
        return obj -> g.apply((RestartChannelPipelinesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private List<String> pipelineIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestartChannelPipelinesRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.pipelineIdsWithStrings(model.pipelineIds);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Collection<String> getPipelineIds() {
            if (this.pipelineIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pipelineIds;
        }

        public final void setPipelineIds(Collection<String> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copy(pipelineIds);
        }

        @Override
        public final Builder pipelineIdsWithStrings(Collection<String> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copy(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIdsWithStrings(String ... pipelineIds) {
            this.pipelineIdsWithStrings(Arrays.asList(pipelineIds));
            return this;
        }

        @Override
        public final Builder pipelineIds(Collection<ChannelPipelineIdToRestart> pipelineIds) {
            this.pipelineIds = ___listOfChannelPipelineIdToRestartCopier.copyEnumToString(pipelineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineIds(ChannelPipelineIdToRestart ... pipelineIds) {
            this.pipelineIds(Arrays.asList(pipelineIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestartChannelPipelinesRequest build() {
            return new RestartChannelPipelinesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestartChannelPipelinesRequest> {
        public Builder channelId(String var1);

        public Builder pipelineIdsWithStrings(Collection<String> var1);

        public Builder pipelineIdsWithStrings(String ... var1);

        public Builder pipelineIds(Collection<ChannelPipelineIdToRestart> var1);

        public Builder pipelineIds(ChannelPipelineIdToRestart ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

