/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceForce;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootInputDeviceRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, RebootInputDeviceRequest> {
    private static final SdkField<String> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Force").getter(RebootInputDeviceRequest.getter(RebootInputDeviceRequest::forceAsString)).setter(RebootInputDeviceRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()}).build();
    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputDeviceId").getter(RebootInputDeviceRequest.getter(RebootInputDeviceRequest::inputDeviceId)).setter(RebootInputDeviceRequest.setter(Builder::inputDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_FIELD, INPUT_DEVICE_ID_FIELD));
    private final String force;
    private final String inputDeviceId;

    private RebootInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.force = builder.force;
        this.inputDeviceId = builder.inputDeviceId;
    }

    public final RebootInputDeviceForce force() {
        return RebootInputDeviceForce.fromValue(this.force);
    }

    public final String forceAsString() {
        return this.force;
    }

    public final String inputDeviceId() {
        return this.inputDeviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDeviceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootInputDeviceRequest)) {
            return false;
        }
        RebootInputDeviceRequest other = (RebootInputDeviceRequest)((Object)obj);
        return Objects.equals(this.forceAsString(), other.forceAsString()) && Objects.equals(this.inputDeviceId(), other.inputDeviceId());
    }

    public final String toString() {
        return ToString.builder((String)"RebootInputDeviceRequest").add("Force", (Object)this.forceAsString()).add("InputDeviceId", (Object)this.inputDeviceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.forceAsString()));
            }
            case "InputDeviceId": {
                return Optional.ofNullable(clazz.cast(this.inputDeviceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootInputDeviceRequest, T> g) {
        return obj -> g.apply((RebootInputDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String force;
        private String inputDeviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootInputDeviceRequest model) {
            super(model);
            this.force(model.force);
            this.inputDeviceId(model.inputDeviceId);
        }

        public final String getForce() {
            return this.force;
        }

        public final void setForce(String force) {
            this.force = force;
        }

        @Override
        public final Builder force(String force) {
            this.force = force;
            return this;
        }

        @Override
        public final Builder force(RebootInputDeviceForce force) {
            this.force(force == null ? null : force.toString());
            return this;
        }

        public final String getInputDeviceId() {
            return this.inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootInputDeviceRequest build() {
            return new RebootInputDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebootInputDeviceRequest> {
        public Builder force(String var1);

        public Builder force(RebootInputDeviceForce var1);

        public Builder inputDeviceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

