/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum M2tsAudioStreamType {
    ATSC("ATSC"),
    DVB("DVB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, M2tsAudioStreamType> VALUE_MAP;
    private final String value;

    private M2tsAudioStreamType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static M2tsAudioStreamType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<M2tsAudioStreamType> knownValues() {
        EnumSet<M2tsAudioStreamType> knownValues = EnumSet.allOf(M2tsAudioStreamType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(M2tsAudioStreamType.class, M2tsAudioStreamType::toString);
    }
}

