/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputDeviceCodec {
    HEVC("HEVC"),
    AVC("AVC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputDeviceCodec> VALUE_MAP;
    private final String value;

    private InputDeviceCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputDeviceCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputDeviceCodec> knownValues() {
        EnumSet<InputDeviceCodec> knownValues = EnumSet.allOf(InputDeviceCodec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputDeviceCodec.class, InputDeviceCodec::toString);
    }
}

