/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AacInputType {
    BROADCASTER_MIXED_AD("BROADCASTER_MIXED_AD"),
    NORMAL("NORMAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AacInputType> VALUE_MAP;
    private final String value;

    private AacInputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AacInputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AacInputType> knownValues() {
        EnumSet<AacInputType> knownValues = EnumSet.allOf(AacInputType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AacInputType.class, AacInputType::toString);
    }
}

