/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceConfigurableSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceConfigurableSettings> {
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfiguredInput").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::configuredInputAsString)).setter(InputDeviceConfigurableSettings.setter(Builder::configuredInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::maxBitrate)).setter(InputDeviceConfigurableSettings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> LATENCY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatencyMs").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::latencyMs)).setter(InputDeviceConfigurableSettings.setter(Builder::latencyMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_INPUT_FIELD, MAX_BITRATE_FIELD, LATENCY_MS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configuredInput;
    private final Integer maxBitrate;
    private final Integer latencyMs;

    private InputDeviceConfigurableSettings(BuilderImpl builder) {
        this.configuredInput = builder.configuredInput;
        this.maxBitrate = builder.maxBitrate;
        this.latencyMs = builder.latencyMs;
    }

    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(this.configuredInput);
    }

    public final String configuredInputAsString() {
        return this.configuredInput;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer latencyMs() {
        return this.latencyMs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyMs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableSettings)) {
            return false;
        }
        InputDeviceConfigurableSettings other = (InputDeviceConfigurableSettings)obj;
        return Objects.equals(this.configuredInputAsString(), other.configuredInputAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.latencyMs(), other.latencyMs());
    }

    public final String toString() {
        return ToString.builder((String)"InputDeviceConfigurableSettings").add("ConfiguredInput", (Object)this.configuredInputAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("LatencyMs", (Object)this.latencyMs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfiguredInput": {
                return Optional.ofNullable(clazz.cast(this.configuredInputAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "LatencyMs": {
                return Optional.ofNullable(clazz.cast(this.latencyMs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceConfigurableSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configuredInput;
        private Integer maxBitrate;
        private Integer latencyMs;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableSettings model) {
            this.configuredInput(model.configuredInput);
            this.maxBitrate(model.maxBitrate);
            this.latencyMs(model.latencyMs);
        }

        public final String getConfiguredInput() {
            return this.configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getLatencyMs() {
            return this.latencyMs;
        }

        public final void setLatencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
        }

        @Override
        public final Builder latencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public InputDeviceConfigurableSettings build() {
            return new InputDeviceConfigurableSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceConfigurableSettings> {
        public Builder configuredInput(String var1);

        public Builder configuredInput(InputDeviceConfiguredInput var1);

        public Builder maxBitrate(Integer var1);

        public Builder latencyMs(Integer var1);
    }
}

