/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelClass {
    STANDARD("STANDARD"),
    SINGLE_PIPELINE("SINGLE_PIPELINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelClass> VALUE_MAP;
    private final String value;

    private ChannelClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelClass> knownValues() {
        EnumSet<ChannelClass> knownValues = EnumSet.allOf(ChannelClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelClass.class, ChannelClass::toString);
    }
}

