/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessibilityType {
    DOES_NOT_IMPLEMENT_ACCESSIBILITY_FEATURES("DOES_NOT_IMPLEMENT_ACCESSIBILITY_FEATURES"),
    IMPLEMENTS_ACCESSIBILITY_FEATURES("IMPLEMENTS_ACCESSIBILITY_FEATURES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessibilityType> VALUE_MAP;
    private final String value;

    private AccessibilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessibilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessibilityType> knownValues() {
        EnumSet<AccessibilityType> knownValues = EnumSet.allOf(AccessibilityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessibilityType.class, AccessibilityType::toString);
    }
}

