/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcOutputSettings> {
    private static final SdkField<List<String>> PUBLIC_ADDRESS_ALLOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicAddressAllocationIds").getter(VpcOutputSettings.getter(VpcOutputSettings::publicAddressAllocationIds)).setter(VpcOutputSettings.setter(Builder::publicAddressAllocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAddressAllocationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VpcOutputSettings.getter(VpcOutputSettings::securityGroupIds)).setter(VpcOutputSettings.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VpcOutputSettings.getter(VpcOutputSettings::subnetIds)).setter(VpcOutputSettings.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_ADDRESS_ALLOCATION_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> publicAddressAllocationIds;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;

    private VpcOutputSettings(BuilderImpl builder) {
        this.publicAddressAllocationIds = builder.publicAddressAllocationIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
    }

    public final boolean hasPublicAddressAllocationIds() {
        return this.publicAddressAllocationIds != null && !(this.publicAddressAllocationIds instanceof SdkAutoConstructList);
    }

    public final List<String> publicAddressAllocationIds() {
        return this.publicAddressAllocationIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicAddressAllocationIds() ? this.publicAddressAllocationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOutputSettings)) {
            return false;
        }
        VpcOutputSettings other = (VpcOutputSettings)obj;
        return this.hasPublicAddressAllocationIds() == other.hasPublicAddressAllocationIds() && Objects.equals(this.publicAddressAllocationIds(), other.publicAddressAllocationIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public final String toString() {
        return ToString.builder((String)"VpcOutputSettings").add("PublicAddressAllocationIds", this.hasPublicAddressAllocationIds() ? this.publicAddressAllocationIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublicAddressAllocationIds": {
                return Optional.ofNullable(clazz.cast(this.publicAddressAllocationIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcOutputSettings, T> g) {
        return obj -> g.apply((VpcOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> publicAddressAllocationIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOutputSettings model) {
            this.publicAddressAllocationIds(model.publicAddressAllocationIds);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
        }

        public final Collection<String> getPublicAddressAllocationIds() {
            if (this.publicAddressAllocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicAddressAllocationIds;
        }

        public final void setPublicAddressAllocationIds(Collection<String> publicAddressAllocationIds) {
            this.publicAddressAllocationIds = ___listOf__stringCopier.copy(publicAddressAllocationIds);
        }

        @Override
        public final Builder publicAddressAllocationIds(Collection<String> publicAddressAllocationIds) {
            this.publicAddressAllocationIds = ___listOf__stringCopier.copy(publicAddressAllocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicAddressAllocationIds(String ... publicAddressAllocationIds) {
            this.publicAddressAllocationIds(Arrays.asList(publicAddressAllocationIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public VpcOutputSettings build() {
            return new VpcOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcOutputSettings> {
        public Builder publicAddressAllocationIds(Collection<String> var1);

        public Builder publicAddressAllocationIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

