/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The Renewal settings for Reservations
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewalSettings implements SdkPojo, Serializable, ToCopyableBuilder<RenewalSettings.Builder, RenewalSettings> {
    private static final SdkField<String> AUTOMATIC_RENEWAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomaticRenewal").getter(getter(RenewalSettings::automaticRenewalAsString))
            .setter(setter(Builder::automaticRenewal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticRenewal").build()).build();

    private static final SdkField<Integer> RENEWAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RenewalCount").getter(getter(RenewalSettings::renewalCount)).setter(setter(Builder::renewalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_RENEWAL_FIELD,
            RENEWAL_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String automaticRenewal;

    private final Integer renewalCount;

    private RenewalSettings(BuilderImpl builder) {
        this.automaticRenewal = builder.automaticRenewal;
        this.renewalCount = builder.renewalCount;
    }

    /**
     * Automatic renewal status for the reservation
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticRenewal}
     * will return {@link ReservationAutomaticRenewal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticRenewalAsString}.
     * </p>
     * 
     * @return Automatic renewal status for the reservation
     * @see ReservationAutomaticRenewal
     */
    public final ReservationAutomaticRenewal automaticRenewal() {
        return ReservationAutomaticRenewal.fromValue(automaticRenewal);
    }

    /**
     * Automatic renewal status for the reservation
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automaticRenewal}
     * will return {@link ReservationAutomaticRenewal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #automaticRenewalAsString}.
     * </p>
     * 
     * @return Automatic renewal status for the reservation
     * @see ReservationAutomaticRenewal
     */
    public final String automaticRenewalAsString() {
        return automaticRenewal;
    }

    /**
     * Count for the reservation renewal
     * 
     * @return Count for the reservation renewal
     */
    public final Integer renewalCount() {
        return renewalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticRenewalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renewalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSettings)) {
            return false;
        }
        RenewalSettings other = (RenewalSettings) obj;
        return Objects.equals(automaticRenewalAsString(), other.automaticRenewalAsString())
                && Objects.equals(renewalCount(), other.renewalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenewalSettings").add("AutomaticRenewal", automaticRenewalAsString())
                .add("RenewalCount", renewalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticRenewal":
            return Optional.ofNullable(clazz.cast(automaticRenewalAsString()));
        case "RenewalCount":
            return Optional.ofNullable(clazz.cast(renewalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSettings, T> g) {
        return obj -> g.apply((RenewalSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenewalSettings> {
        /**
         * Automatic renewal status for the reservation
         * 
         * @param automaticRenewal
         *        Automatic renewal status for the reservation
         * @see ReservationAutomaticRenewal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationAutomaticRenewal
         */
        Builder automaticRenewal(String automaticRenewal);

        /**
         * Automatic renewal status for the reservation
         * 
         * @param automaticRenewal
         *        Automatic renewal status for the reservation
         * @see ReservationAutomaticRenewal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationAutomaticRenewal
         */
        Builder automaticRenewal(ReservationAutomaticRenewal automaticRenewal);

        /**
         * Count for the reservation renewal
         * 
         * @param renewalCount
         *        Count for the reservation renewal
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalCount(Integer renewalCount);
    }

    static final class BuilderImpl implements Builder {
        private String automaticRenewal;

        private Integer renewalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSettings model) {
            automaticRenewal(model.automaticRenewal);
            renewalCount(model.renewalCount);
        }

        public final String getAutomaticRenewal() {
            return automaticRenewal;
        }

        public final void setAutomaticRenewal(String automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
        }

        @Override
        public final Builder automaticRenewal(String automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
            return this;
        }

        @Override
        public final Builder automaticRenewal(ReservationAutomaticRenewal automaticRenewal) {
            this.automaticRenewal(automaticRenewal == null ? null : automaticRenewal.toString());
            return this;
        }

        public final Integer getRenewalCount() {
            return renewalCount;
        }

        public final void setRenewalCount(Integer renewalCount) {
            this.renewalCount = renewalCount;
        }

        @Override
        public final Builder renewalCount(Integer renewalCount) {
            this.renewalCount = renewalCount;
            return this;
        }

        @Override
        public RenewalSettings build() {
            return new RenewalSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
