/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Input Channel Level
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputChannelLevel implements SdkPojo, Serializable,
        ToCopyableBuilder<InputChannelLevel.Builder, InputChannelLevel> {
    private static final SdkField<Integer> GAIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Gain")
            .getter(getter(InputChannelLevel::gain)).setter(setter(Builder::gain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gain").build()).build();

    private static final SdkField<Integer> INPUT_CHANNEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputChannel").getter(getter(InputChannelLevel::inputChannel)).setter(setter(Builder::inputChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAIN_FIELD,
            INPUT_CHANNEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer gain;

    private final Integer inputChannel;

    private InputChannelLevel(BuilderImpl builder) {
        this.gain = builder.gain;
        this.inputChannel = builder.inputChannel;
    }

    /**
     * Remixing value. Units are in dB and acceptable values are within the range from -60 (mute) and 6 dB.
     * 
     * @return Remixing value. Units are in dB and acceptable values are within the range from -60 (mute) and 6 dB.
     */
    public final Integer gain() {
        return gain;
    }

    /**
     * The index of the input channel used as a source.
     * 
     * @return The index of the input channel used as a source.
     */
    public final Integer inputChannel() {
        return inputChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gain());
        hashCode = 31 * hashCode + Objects.hashCode(inputChannel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputChannelLevel)) {
            return false;
        }
        InputChannelLevel other = (InputChannelLevel) obj;
        return Objects.equals(gain(), other.gain()) && Objects.equals(inputChannel(), other.inputChannel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputChannelLevel").add("Gain", gain()).add("InputChannel", inputChannel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Gain":
            return Optional.ofNullable(clazz.cast(gain()));
        case "InputChannel":
            return Optional.ofNullable(clazz.cast(inputChannel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputChannelLevel, T> g) {
        return obj -> g.apply((InputChannelLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputChannelLevel> {
        /**
         * Remixing value. Units are in dB and acceptable values are within the range from -60 (mute) and 6 dB.
         * 
         * @param gain
         *        Remixing value. Units are in dB and acceptable values are within the range from -60 (mute) and 6 dB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gain(Integer gain);

        /**
         * The index of the input channel used as a source.
         * 
         * @param inputChannel
         *        The index of the input channel used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputChannel(Integer inputChannel);
    }

    static final class BuilderImpl implements Builder {
        private Integer gain;

        private Integer inputChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(InputChannelLevel model) {
            gain(model.gain);
            inputChannel(model.inputChannel);
        }

        public final Integer getGain() {
            return gain;
        }

        public final void setGain(Integer gain) {
            this.gain = gain;
        }

        @Override
        public final Builder gain(Integer gain) {
            this.gain = gain;
            return this;
        }

        public final Integer getInputChannel() {
            return inputChannel;
        }

        public final void setInputChannel(Integer inputChannel) {
            this.inputChannel = inputChannel;
        }

        @Override
        public final Builder inputChannel(Integer inputChannel) {
            this.inputChannel = inputChannel;
            return this;
        }

        @Override
        public InputChannelLevel build() {
            return new InputChannelLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
