/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Failover Condition settings. There can be multiple failover conditions inside AutomaticInputFailoverSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<FailoverCondition.Builder, FailoverCondition> {
    private static final SdkField<FailoverConditionSettings> FAILOVER_CONDITION_SETTINGS_FIELD = SdkField
            .<FailoverConditionSettings> builder(MarshallingType.SDK_POJO).memberName("FailoverConditionSettings")
            .getter(getter(FailoverCondition::failoverConditionSettings)).setter(setter(Builder::failoverConditionSettings))
            .constructor(FailoverConditionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverConditionSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILOVER_CONDITION_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FailoverConditionSettings failoverConditionSettings;

    private FailoverCondition(BuilderImpl builder) {
        this.failoverConditionSettings = builder.failoverConditionSettings;
    }

    /**
     * Failover condition type-specific settings.
     * 
     * @return Failover condition type-specific settings.
     */
    public final FailoverConditionSettings failoverConditionSettings() {
        return failoverConditionSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failoverConditionSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverCondition)) {
            return false;
        }
        FailoverCondition other = (FailoverCondition) obj;
        return Objects.equals(failoverConditionSettings(), other.failoverConditionSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverCondition").add("FailoverConditionSettings", failoverConditionSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailoverConditionSettings":
            return Optional.ofNullable(clazz.cast(failoverConditionSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverCondition, T> g) {
        return obj -> g.apply((FailoverCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailoverCondition> {
        /**
         * Failover condition type-specific settings.
         * 
         * @param failoverConditionSettings
         *        Failover condition type-specific settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverConditionSettings(FailoverConditionSettings failoverConditionSettings);

        /**
         * Failover condition type-specific settings. This is a convenience method that creates an instance of the
         * {@link FailoverConditionSettings.Builder} avoiding the need to create one manually via
         * {@link FailoverConditionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FailoverConditionSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #failoverConditionSettings(FailoverConditionSettings)}.
         * 
         * @param failoverConditionSettings
         *        a consumer that will call methods on {@link FailoverConditionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverConditionSettings(FailoverConditionSettings)
         */
        default Builder failoverConditionSettings(Consumer<FailoverConditionSettings.Builder> failoverConditionSettings) {
            return failoverConditionSettings(FailoverConditionSettings.builder().applyMutation(failoverConditionSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FailoverConditionSettings failoverConditionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverCondition model) {
            failoverConditionSettings(model.failoverConditionSettings);
        }

        public final FailoverConditionSettings.Builder getFailoverConditionSettings() {
            return failoverConditionSettings != null ? failoverConditionSettings.toBuilder() : null;
        }

        public final void setFailoverConditionSettings(FailoverConditionSettings.BuilderImpl failoverConditionSettings) {
            this.failoverConditionSettings = failoverConditionSettings != null ? failoverConditionSettings.build() : null;
        }

        @Override
        public final Builder failoverConditionSettings(FailoverConditionSettings failoverConditionSettings) {
            this.failoverConditionSettings = failoverConditionSettings;
            return this;
        }

        @Override
        public FailoverCondition build() {
            return new FailoverCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
