/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsOutputSelection {
    MANIFESTS_AND_SEGMENTS("MANIFESTS_AND_SEGMENTS"),
    SEGMENTS_ONLY("SEGMENTS_ONLY"),
    VARIANT_MANIFESTS_AND_SEGMENTS("VARIANT_MANIFESTS_AND_SEGMENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsOutputSelection> VALUE_MAP;
    private final String value;

    private HlsOutputSelection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsOutputSelection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsOutputSelection> knownValues() {
        EnumSet<HlsOutputSelection> knownValues = EnumSet.allOf(HlsOutputSelection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsOutputSelection.class, HlsOutputSelection::toString);
    }
}

