/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264ScanType {
    INTERLACED("INTERLACED"),
    PROGRESSIVE("PROGRESSIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264ScanType> VALUE_MAP;
    private final String value;

    private H264ScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264ScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264ScanType> knownValues() {
        EnumSet<H264ScanType> knownValues = EnumSet.allOf(H264ScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264ScanType.class, H264ScanType::toString);
    }
}

