/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ReservationAutomaticRenewal;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenewalSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RenewalSettings> {
    private static final SdkField<String> AUTOMATIC_RENEWAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomaticRenewal").getter(RenewalSettings.getter(RenewalSettings::automaticRenewalAsString)).setter(RenewalSettings.setter(Builder::automaticRenewal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticRenewal").build()}).build();
    private static final SdkField<Integer> RENEWAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RenewalCount").getter(RenewalSettings.getter(RenewalSettings::renewalCount)).setter(RenewalSettings.setter(Builder::renewalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATIC_RENEWAL_FIELD, RENEWAL_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automaticRenewal;
    private final Integer renewalCount;

    private RenewalSettings(BuilderImpl builder) {
        this.automaticRenewal = builder.automaticRenewal;
        this.renewalCount = builder.renewalCount;
    }

    public final ReservationAutomaticRenewal automaticRenewal() {
        return ReservationAutomaticRenewal.fromValue(this.automaticRenewal);
    }

    public final String automaticRenewalAsString() {
        return this.automaticRenewal;
    }

    public final Integer renewalCount() {
        return this.renewalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticRenewalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSettings)) {
            return false;
        }
        RenewalSettings other = (RenewalSettings)obj;
        return Objects.equals(this.automaticRenewalAsString(), other.automaticRenewalAsString()) && Objects.equals(this.renewalCount(), other.renewalCount());
    }

    public final String toString() {
        return ToString.builder((String)"RenewalSettings").add("AutomaticRenewal", (Object)this.automaticRenewalAsString()).add("RenewalCount", (Object)this.renewalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomaticRenewal": {
                return Optional.ofNullable(clazz.cast(this.automaticRenewalAsString()));
            }
            case "RenewalCount": {
                return Optional.ofNullable(clazz.cast(this.renewalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSettings, T> g) {
        return obj -> g.apply((RenewalSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automaticRenewal;
        private Integer renewalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSettings model) {
            this.automaticRenewal(model.automaticRenewal);
            this.renewalCount(model.renewalCount);
        }

        public final String getAutomaticRenewal() {
            return this.automaticRenewal;
        }

        public final void setAutomaticRenewal(String automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
        }

        @Override
        public final Builder automaticRenewal(String automaticRenewal) {
            this.automaticRenewal = automaticRenewal;
            return this;
        }

        @Override
        public final Builder automaticRenewal(ReservationAutomaticRenewal automaticRenewal) {
            this.automaticRenewal(automaticRenewal == null ? null : automaticRenewal.toString());
            return this;
        }

        public final Integer getRenewalCount() {
            return this.renewalCount;
        }

        public final void setRenewalCount(Integer renewalCount) {
            this.renewalCount = renewalCount;
        }

        @Override
        public final Builder renewalCount(Integer renewalCount) {
            this.renewalCount = renewalCount;
            return this;
        }

        public RenewalSettings build() {
            return new RenewalSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RenewalSettings> {
        public Builder automaticRenewal(String var1);

        public Builder automaticRenewal(ReservationAutomaticRenewal var1);

        public Builder renewalCount(Integer var1);
    }
}

