/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Mpeg2ScanType {
    INTERLACED("INTERLACED"),
    PROGRESSIVE("PROGRESSIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mpeg2ScanType> VALUE_MAP;
    private final String value;

    private Mpeg2ScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Mpeg2ScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Mpeg2ScanType> knownValues() {
        EnumSet<Mpeg2ScanType> knownValues = EnumSet.allOf(Mpeg2ScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Mpeg2ScanType.class, Mpeg2ScanType::toString);
    }
}

