/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputDeviceTransferType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransferringInputDeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransferringInputDeviceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(TransferringInputDeviceSummary.getter(TransferringInputDeviceSummary::id)).setter(TransferringInputDeviceSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(TransferringInputDeviceSummary.getter(TransferringInputDeviceSummary::message)).setter(TransferringInputDeviceSummary.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> TARGET_CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCustomerId").getter(TransferringInputDeviceSummary.getter(TransferringInputDeviceSummary::targetCustomerId)).setter(TransferringInputDeviceSummary.setter(Builder::targetCustomerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCustomerId").build()}).build();
    private static final SdkField<String> TRANSFER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferType").getter(TransferringInputDeviceSummary.getter(TransferringInputDeviceSummary::transferTypeAsString)).setter(TransferringInputDeviceSummary.setter(Builder::transferType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_FIELD, TARGET_CUSTOMER_ID_FIELD, TRANSFER_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String message;
    private final String targetCustomerId;
    private final String transferType;

    private TransferringInputDeviceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.message = builder.message;
        this.targetCustomerId = builder.targetCustomerId;
        this.transferType = builder.transferType;
    }

    public final String id() {
        return this.id;
    }

    public final String message() {
        return this.message;
    }

    public final String targetCustomerId() {
        return this.targetCustomerId;
    }

    public final InputDeviceTransferType transferType() {
        return InputDeviceTransferType.fromValue(this.transferType);
    }

    public final String transferTypeAsString() {
        return this.transferType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCustomerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferringInputDeviceSummary)) {
            return false;
        }
        TransferringInputDeviceSummary other = (TransferringInputDeviceSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.targetCustomerId(), other.targetCustomerId()) && Objects.equals(this.transferTypeAsString(), other.transferTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransferringInputDeviceSummary").add("Id", (Object)this.id()).add("Message", (Object)this.message()).add("TargetCustomerId", (Object)this.targetCustomerId()).add("TransferType", (Object)this.transferTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "TargetCustomerId": {
                return Optional.ofNullable(clazz.cast(this.targetCustomerId()));
            }
            case "TransferType": {
                return Optional.ofNullable(clazz.cast(this.transferTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransferringInputDeviceSummary, T> g) {
        return obj -> g.apply((TransferringInputDeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String message;
        private String targetCustomerId;
        private String transferType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferringInputDeviceSummary model) {
            this.id(model.id);
            this.message(model.message);
            this.targetCustomerId(model.targetCustomerId);
            this.transferType(model.transferType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getTargetCustomerId() {
            return this.targetCustomerId;
        }

        public final void setTargetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
        }

        @Override
        @Transient
        public final Builder targetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
            return this;
        }

        public final String getTransferType() {
            return this.transferType;
        }

        public final void setTransferType(String transferType) {
            this.transferType = transferType;
        }

        @Override
        @Transient
        public final Builder transferType(String transferType) {
            this.transferType = transferType;
            return this;
        }

        @Override
        @Transient
        public final Builder transferType(InputDeviceTransferType transferType) {
            this.transferType(transferType == null ? null : transferType.toString());
            return this;
        }

        public TransferringInputDeviceSummary build() {
            return new TransferringInputDeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransferringInputDeviceSummary> {
        public Builder id(String var1);

        public Builder message(String var1);

        public Builder targetCustomerId(String var1);

        public Builder transferType(String var1);

        public Builder transferType(InputDeviceTransferType var1);
    }
}

