/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioSilenceFailoverSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioSilenceFailoverSettings> {
    private static final SdkField<String> AUDIO_SELECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioSelectorName").getter(AudioSilenceFailoverSettings.getter(AudioSilenceFailoverSettings::audioSelectorName)).setter(AudioSilenceFailoverSettings.setter(Builder::audioSelectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorName").build()}).build();
    private static final SdkField<Integer> AUDIO_SILENCE_THRESHOLD_MSEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AudioSilenceThresholdMsec").getter(AudioSilenceFailoverSettings.getter(AudioSilenceFailoverSettings::audioSilenceThresholdMsec)).setter(AudioSilenceFailoverSettings.setter(Builder::audioSilenceThresholdMsec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSilenceThresholdMsec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTOR_NAME_FIELD, AUDIO_SILENCE_THRESHOLD_MSEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioSelectorName;
    private final Integer audioSilenceThresholdMsec;

    private AudioSilenceFailoverSettings(BuilderImpl builder) {
        this.audioSelectorName = builder.audioSelectorName;
        this.audioSilenceThresholdMsec = builder.audioSilenceThresholdMsec;
    }

    public final String audioSelectorName() {
        return this.audioSelectorName;
    }

    public final Integer audioSilenceThresholdMsec() {
        return this.audioSilenceThresholdMsec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSilenceThresholdMsec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSilenceFailoverSettings)) {
            return false;
        }
        AudioSilenceFailoverSettings other = (AudioSilenceFailoverSettings)obj;
        return Objects.equals(this.audioSelectorName(), other.audioSelectorName()) && Objects.equals(this.audioSilenceThresholdMsec(), other.audioSilenceThresholdMsec());
    }

    public final String toString() {
        return ToString.builder((String)"AudioSilenceFailoverSettings").add("AudioSelectorName", (Object)this.audioSelectorName()).add("AudioSilenceThresholdMsec", (Object)this.audioSilenceThresholdMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioSelectorName": {
                return Optional.ofNullable(clazz.cast(this.audioSelectorName()));
            }
            case "AudioSilenceThresholdMsec": {
                return Optional.ofNullable(clazz.cast(this.audioSilenceThresholdMsec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSilenceFailoverSettings, T> g) {
        return obj -> g.apply((AudioSilenceFailoverSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioSelectorName;
        private Integer audioSilenceThresholdMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSilenceFailoverSettings model) {
            this.audioSelectorName(model.audioSelectorName);
            this.audioSilenceThresholdMsec(model.audioSilenceThresholdMsec);
        }

        public final String getAudioSelectorName() {
            return this.audioSelectorName;
        }

        public final void setAudioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
        }

        @Override
        @Transient
        public final Builder audioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
            return this;
        }

        public final Integer getAudioSilenceThresholdMsec() {
            return this.audioSilenceThresholdMsec;
        }

        public final void setAudioSilenceThresholdMsec(Integer audioSilenceThresholdMsec) {
            this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
        }

        @Override
        @Transient
        public final Builder audioSilenceThresholdMsec(Integer audioSilenceThresholdMsec) {
            this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
            return this;
        }

        public AudioSilenceFailoverSettings build() {
            return new AudioSilenceFailoverSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioSilenceFailoverSettings> {
        public Builder audioSelectorName(String var1);

        public Builder audioSilenceThresholdMsec(Integer var1);
    }
}

