/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDeviceIpScheme;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceNetworkSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceNetworkSettings> {
    private static final SdkField<List<String>> DNS_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsAddresses").getter(InputDeviceNetworkSettings.getter(InputDeviceNetworkSettings::dnsAddresses)).setter(InputDeviceNetworkSettings.setter(Builder::dnsAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gateway").getter(InputDeviceNetworkSettings.getter(InputDeviceNetworkSettings::gateway)).setter(InputDeviceNetworkSettings.setter(Builder::gateway)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateway").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(InputDeviceNetworkSettings.getter(InputDeviceNetworkSettings::ipAddress)).setter(InputDeviceNetworkSettings.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> IP_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpScheme").getter(InputDeviceNetworkSettings.getter(InputDeviceNetworkSettings::ipSchemeAsString)).setter(InputDeviceNetworkSettings.setter(Builder::ipScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipScheme").build()}).build();
    private static final SdkField<String> SUBNET_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetMask").getter(InputDeviceNetworkSettings.getter(InputDeviceNetworkSettings::subnetMask)).setter(InputDeviceNetworkSettings.setter(Builder::subnetMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetMask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_ADDRESSES_FIELD, GATEWAY_FIELD, IP_ADDRESS_FIELD, IP_SCHEME_FIELD, SUBNET_MASK_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> dnsAddresses;
    private final String gateway;
    private final String ipAddress;
    private final String ipScheme;
    private final String subnetMask;

    private InputDeviceNetworkSettings(BuilderImpl builder) {
        this.dnsAddresses = builder.dnsAddresses;
        this.gateway = builder.gateway;
        this.ipAddress = builder.ipAddress;
        this.ipScheme = builder.ipScheme;
        this.subnetMask = builder.subnetMask;
    }

    public final boolean hasDnsAddresses() {
        return this.dnsAddresses != null && !(this.dnsAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> dnsAddresses() {
        return this.dnsAddresses;
    }

    public final String gateway() {
        return this.gateway;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final InputDeviceIpScheme ipScheme() {
        return InputDeviceIpScheme.fromValue(this.ipScheme);
    }

    public final String ipSchemeAsString() {
        return this.ipScheme;
    }

    public final String subnetMask() {
        return this.subnetMask;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsAddresses() ? this.dnsAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gateway());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMask());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceNetworkSettings)) {
            return false;
        }
        InputDeviceNetworkSettings other = (InputDeviceNetworkSettings)obj;
        return this.hasDnsAddresses() == other.hasDnsAddresses() && Objects.equals(this.dnsAddresses(), other.dnsAddresses()) && Objects.equals(this.gateway(), other.gateway()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.ipSchemeAsString(), other.ipSchemeAsString()) && Objects.equals(this.subnetMask(), other.subnetMask());
    }

    public final String toString() {
        return ToString.builder((String)"InputDeviceNetworkSettings").add("DnsAddresses", this.hasDnsAddresses() ? this.dnsAddresses() : null).add("Gateway", (Object)this.gateway()).add("IpAddress", (Object)this.ipAddress()).add("IpScheme", (Object)this.ipSchemeAsString()).add("SubnetMask", (Object)this.subnetMask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsAddresses": {
                return Optional.ofNullable(clazz.cast(this.dnsAddresses()));
            }
            case "Gateway": {
                return Optional.ofNullable(clazz.cast(this.gateway()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "IpScheme": {
                return Optional.ofNullable(clazz.cast(this.ipSchemeAsString()));
            }
            case "SubnetMask": {
                return Optional.ofNullable(clazz.cast(this.subnetMask()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceNetworkSettings, T> g) {
        return obj -> g.apply((InputDeviceNetworkSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dnsAddresses = DefaultSdkAutoConstructList.getInstance();
        private String gateway;
        private String ipAddress;
        private String ipScheme;
        private String subnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceNetworkSettings model) {
            this.dnsAddresses(model.dnsAddresses);
            this.gateway(model.gateway);
            this.ipAddress(model.ipAddress);
            this.ipScheme(model.ipScheme);
            this.subnetMask(model.subnetMask);
        }

        public final Collection<String> getDnsAddresses() {
            if (this.dnsAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsAddresses;
        }

        public final void setDnsAddresses(Collection<String> dnsAddresses) {
            this.dnsAddresses = ___listOf__stringCopier.copy(dnsAddresses);
        }

        @Override
        @Transient
        public final Builder dnsAddresses(Collection<String> dnsAddresses) {
            this.dnsAddresses = ___listOf__stringCopier.copy(dnsAddresses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dnsAddresses(String ... dnsAddresses) {
            this.dnsAddresses(Arrays.asList(dnsAddresses));
            return this;
        }

        public final String getGateway() {
            return this.gateway;
        }

        public final void setGateway(String gateway) {
            this.gateway = gateway;
        }

        @Override
        @Transient
        public final Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getIpScheme() {
            return this.ipScheme;
        }

        public final void setIpScheme(String ipScheme) {
            this.ipScheme = ipScheme;
        }

        @Override
        @Transient
        public final Builder ipScheme(String ipScheme) {
            this.ipScheme = ipScheme;
            return this;
        }

        @Override
        @Transient
        public final Builder ipScheme(InputDeviceIpScheme ipScheme) {
            this.ipScheme(ipScheme == null ? null : ipScheme.toString());
            return this;
        }

        public final String getSubnetMask() {
            return this.subnetMask;
        }

        public final void setSubnetMask(String subnetMask) {
            this.subnetMask = subnetMask;
        }

        @Override
        @Transient
        public final Builder subnetMask(String subnetMask) {
            this.subnetMask = subnetMask;
            return this;
        }

        public InputDeviceNetworkSettings build() {
            return new InputDeviceNetworkSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceNetworkSettings> {
        public Builder dnsAddresses(Collection<String> var1);

        public Builder dnsAddresses(String ... var1);

        public Builder gateway(String var1);

        public Builder ipAddress(String var1);

        public Builder ipScheme(String var1);

        public Builder ipScheme(InputDeviceIpScheme var1);

        public Builder subnetMask(String var1);
    }
}

