/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.InputDeviceSummary;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;

public class ListInputDevicesIterable
implements SdkIterable<ListInputDevicesResponse> {
    private final MediaLiveClient client;
    private final ListInputDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInputDevicesIterable(MediaLiveClient client, ListInputDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputDevicesResponseFetcher();
    }

    public Iterator<ListInputDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InputDeviceSummary> inputDevices() {
        Function<ListInputDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputDevices() != null) {
                return response.inputDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInputDevicesResponseFetcher
    implements SyncPageFetcher<ListInputDevicesResponse> {
        private ListInputDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListInputDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInputDevicesResponse nextPage(ListInputDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListInputDevicesIterable.this.client.listInputDevices(ListInputDevicesIterable.this.firstRequest);
            }
            return ListInputDevicesIterable.this.client.listInputDevices((ListInputDevicesRequest)((Object)ListInputDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

