/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings;
import software.amazon.awssdk.services.medialive.model.FrameCaptureGroupSettings;
import software.amazon.awssdk.services.medialive.model.HlsGroupSettings;
import software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings;
import software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings;
import software.amazon.awssdk.services.medialive.model.MultiplexGroupSettings;
import software.amazon.awssdk.services.medialive.model.RtmpGroupSettings;
import software.amazon.awssdk.services.medialive.model.UdpGroupSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputGroupSettings> {
    private static final SdkField<ArchiveGroupSettings> ARCHIVE_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchiveGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::archiveGroupSettings)).setter(OutputGroupSettings.setter(Builder::archiveGroupSettings)).constructor(ArchiveGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveGroupSettings").build()}).build();
    private static final SdkField<FrameCaptureGroupSettings> FRAME_CAPTURE_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameCaptureGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::frameCaptureGroupSettings)).setter(OutputGroupSettings.setter(Builder::frameCaptureGroupSettings)).constructor(FrameCaptureGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureGroupSettings").build()}).build();
    private static final SdkField<HlsGroupSettings> HLS_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::hlsGroupSettings)).setter(OutputGroupSettings.setter(Builder::hlsGroupSettings)).constructor(HlsGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsGroupSettings").build()}).build();
    private static final SdkField<MediaPackageGroupSettings> MEDIA_PACKAGE_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaPackageGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::mediaPackageGroupSettings)).setter(OutputGroupSettings.setter(Builder::mediaPackageGroupSettings)).constructor(MediaPackageGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageGroupSettings").build()}).build();
    private static final SdkField<MsSmoothGroupSettings> MS_SMOOTH_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MsSmoothGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::msSmoothGroupSettings)).setter(OutputGroupSettings.setter(Builder::msSmoothGroupSettings)).constructor(MsSmoothGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothGroupSettings").build()}).build();
    private static final SdkField<MultiplexGroupSettings> MULTIPLEX_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::multiplexGroupSettings)).setter(OutputGroupSettings.setter(Builder::multiplexGroupSettings)).constructor(MultiplexGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexGroupSettings").build()}).build();
    private static final SdkField<RtmpGroupSettings> RTMP_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RtmpGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::rtmpGroupSettings)).setter(OutputGroupSettings.setter(Builder::rtmpGroupSettings)).constructor(RtmpGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpGroupSettings").build()}).build();
    private static final SdkField<UdpGroupSettings> UDP_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UdpGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::udpGroupSettings)).setter(OutputGroupSettings.setter(Builder::udpGroupSettings)).constructor(UdpGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpGroupSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_GROUP_SETTINGS_FIELD, FRAME_CAPTURE_GROUP_SETTINGS_FIELD, HLS_GROUP_SETTINGS_FIELD, MEDIA_PACKAGE_GROUP_SETTINGS_FIELD, MS_SMOOTH_GROUP_SETTINGS_FIELD, MULTIPLEX_GROUP_SETTINGS_FIELD, RTMP_GROUP_SETTINGS_FIELD, UDP_GROUP_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ArchiveGroupSettings archiveGroupSettings;
    private final FrameCaptureGroupSettings frameCaptureGroupSettings;
    private final HlsGroupSettings hlsGroupSettings;
    private final MediaPackageGroupSettings mediaPackageGroupSettings;
    private final MsSmoothGroupSettings msSmoothGroupSettings;
    private final MultiplexGroupSettings multiplexGroupSettings;
    private final RtmpGroupSettings rtmpGroupSettings;
    private final UdpGroupSettings udpGroupSettings;

    private OutputGroupSettings(BuilderImpl builder) {
        this.archiveGroupSettings = builder.archiveGroupSettings;
        this.frameCaptureGroupSettings = builder.frameCaptureGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.mediaPackageGroupSettings = builder.mediaPackageGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.multiplexGroupSettings = builder.multiplexGroupSettings;
        this.rtmpGroupSettings = builder.rtmpGroupSettings;
        this.udpGroupSettings = builder.udpGroupSettings;
    }

    public final ArchiveGroupSettings archiveGroupSettings() {
        return this.archiveGroupSettings;
    }

    public final FrameCaptureGroupSettings frameCaptureGroupSettings() {
        return this.frameCaptureGroupSettings;
    }

    public final HlsGroupSettings hlsGroupSettings() {
        return this.hlsGroupSettings;
    }

    public final MediaPackageGroupSettings mediaPackageGroupSettings() {
        return this.mediaPackageGroupSettings;
    }

    public final MsSmoothGroupSettings msSmoothGroupSettings() {
        return this.msSmoothGroupSettings;
    }

    public final MultiplexGroupSettings multiplexGroupSettings() {
        return this.multiplexGroupSettings;
    }

    public final RtmpGroupSettings rtmpGroupSettings() {
        return this.rtmpGroupSettings;
    }

    public final UdpGroupSettings udpGroupSettings() {
        return this.udpGroupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameCaptureGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaPackageGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rtmpGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.udpGroupSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings)obj;
        return Objects.equals(this.archiveGroupSettings(), other.archiveGroupSettings()) && Objects.equals(this.frameCaptureGroupSettings(), other.frameCaptureGroupSettings()) && Objects.equals(this.hlsGroupSettings(), other.hlsGroupSettings()) && Objects.equals(this.mediaPackageGroupSettings(), other.mediaPackageGroupSettings()) && Objects.equals(this.msSmoothGroupSettings(), other.msSmoothGroupSettings()) && Objects.equals(this.multiplexGroupSettings(), other.multiplexGroupSettings()) && Objects.equals(this.rtmpGroupSettings(), other.rtmpGroupSettings()) && Objects.equals(this.udpGroupSettings(), other.udpGroupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"OutputGroupSettings").add("ArchiveGroupSettings", (Object)this.archiveGroupSettings()).add("FrameCaptureGroupSettings", (Object)this.frameCaptureGroupSettings()).add("HlsGroupSettings", (Object)this.hlsGroupSettings()).add("MediaPackageGroupSettings", (Object)this.mediaPackageGroupSettings()).add("MsSmoothGroupSettings", (Object)this.msSmoothGroupSettings()).add("MultiplexGroupSettings", (Object)this.multiplexGroupSettings()).add("RtmpGroupSettings", (Object)this.rtmpGroupSettings()).add("UdpGroupSettings", (Object)this.udpGroupSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.archiveGroupSettings()));
            }
            case "FrameCaptureGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.frameCaptureGroupSettings()));
            }
            case "HlsGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsGroupSettings()));
            }
            case "MediaPackageGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaPackageGroupSettings()));
            }
            case "MsSmoothGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.msSmoothGroupSettings()));
            }
            case "MultiplexGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexGroupSettings()));
            }
            case "RtmpGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.rtmpGroupSettings()));
            }
            case "UdpGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.udpGroupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroupSettings, T> g) {
        return obj -> g.apply((OutputGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveGroupSettings archiveGroupSettings;
        private FrameCaptureGroupSettings frameCaptureGroupSettings;
        private HlsGroupSettings hlsGroupSettings;
        private MediaPackageGroupSettings mediaPackageGroupSettings;
        private MsSmoothGroupSettings msSmoothGroupSettings;
        private MultiplexGroupSettings multiplexGroupSettings;
        private RtmpGroupSettings rtmpGroupSettings;
        private UdpGroupSettings udpGroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            this.archiveGroupSettings(model.archiveGroupSettings);
            this.frameCaptureGroupSettings(model.frameCaptureGroupSettings);
            this.hlsGroupSettings(model.hlsGroupSettings);
            this.mediaPackageGroupSettings(model.mediaPackageGroupSettings);
            this.msSmoothGroupSettings(model.msSmoothGroupSettings);
            this.multiplexGroupSettings(model.multiplexGroupSettings);
            this.rtmpGroupSettings(model.rtmpGroupSettings);
            this.udpGroupSettings(model.udpGroupSettings);
        }

        public final ArchiveGroupSettings.Builder getArchiveGroupSettings() {
            return this.archiveGroupSettings != null ? this.archiveGroupSettings.toBuilder() : null;
        }

        public final void setArchiveGroupSettings(ArchiveGroupSettings.BuilderImpl archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings != null ? archiveGroupSettings.build() : null;
        }

        @Override
        public final Builder archiveGroupSettings(ArchiveGroupSettings archiveGroupSettings) {
            this.archiveGroupSettings = archiveGroupSettings;
            return this;
        }

        public final FrameCaptureGroupSettings.Builder getFrameCaptureGroupSettings() {
            return this.frameCaptureGroupSettings != null ? this.frameCaptureGroupSettings.toBuilder() : null;
        }

        public final void setFrameCaptureGroupSettings(FrameCaptureGroupSettings.BuilderImpl frameCaptureGroupSettings) {
            this.frameCaptureGroupSettings = frameCaptureGroupSettings != null ? frameCaptureGroupSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureGroupSettings(FrameCaptureGroupSettings frameCaptureGroupSettings) {
            this.frameCaptureGroupSettings = frameCaptureGroupSettings;
            return this;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return this.hlsGroupSettings != null ? this.hlsGroupSettings.toBuilder() : null;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        @Override
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final MediaPackageGroupSettings.Builder getMediaPackageGroupSettings() {
            return this.mediaPackageGroupSettings != null ? this.mediaPackageGroupSettings.toBuilder() : null;
        }

        public final void setMediaPackageGroupSettings(MediaPackageGroupSettings.BuilderImpl mediaPackageGroupSettings) {
            this.mediaPackageGroupSettings = mediaPackageGroupSettings != null ? mediaPackageGroupSettings.build() : null;
        }

        @Override
        public final Builder mediaPackageGroupSettings(MediaPackageGroupSettings mediaPackageGroupSettings) {
            this.mediaPackageGroupSettings = mediaPackageGroupSettings;
            return this;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return this.msSmoothGroupSettings != null ? this.msSmoothGroupSettings.toBuilder() : null;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        @Override
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final MultiplexGroupSettings.Builder getMultiplexGroupSettings() {
            return this.multiplexGroupSettings != null ? this.multiplexGroupSettings.toBuilder() : null;
        }

        public final void setMultiplexGroupSettings(MultiplexGroupSettings.BuilderImpl multiplexGroupSettings) {
            this.multiplexGroupSettings = multiplexGroupSettings != null ? multiplexGroupSettings.build() : null;
        }

        @Override
        public final Builder multiplexGroupSettings(MultiplexGroupSettings multiplexGroupSettings) {
            this.multiplexGroupSettings = multiplexGroupSettings;
            return this;
        }

        public final RtmpGroupSettings.Builder getRtmpGroupSettings() {
            return this.rtmpGroupSettings != null ? this.rtmpGroupSettings.toBuilder() : null;
        }

        public final void setRtmpGroupSettings(RtmpGroupSettings.BuilderImpl rtmpGroupSettings) {
            this.rtmpGroupSettings = rtmpGroupSettings != null ? rtmpGroupSettings.build() : null;
        }

        @Override
        public final Builder rtmpGroupSettings(RtmpGroupSettings rtmpGroupSettings) {
            this.rtmpGroupSettings = rtmpGroupSettings;
            return this;
        }

        public final UdpGroupSettings.Builder getUdpGroupSettings() {
            return this.udpGroupSettings != null ? this.udpGroupSettings.toBuilder() : null;
        }

        public final void setUdpGroupSettings(UdpGroupSettings.BuilderImpl udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings != null ? udpGroupSettings.build() : null;
        }

        @Override
        public final Builder udpGroupSettings(UdpGroupSettings udpGroupSettings) {
            this.udpGroupSettings = udpGroupSettings;
            return this;
        }

        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputGroupSettings> {
        public Builder archiveGroupSettings(ArchiveGroupSettings var1);

        default public Builder archiveGroupSettings(Consumer<ArchiveGroupSettings.Builder> archiveGroupSettings) {
            return this.archiveGroupSettings((ArchiveGroupSettings)((ArchiveGroupSettings.Builder)ArchiveGroupSettings.builder().applyMutation(archiveGroupSettings)).build());
        }

        public Builder frameCaptureGroupSettings(FrameCaptureGroupSettings var1);

        default public Builder frameCaptureGroupSettings(Consumer<FrameCaptureGroupSettings.Builder> frameCaptureGroupSettings) {
            return this.frameCaptureGroupSettings((FrameCaptureGroupSettings)((FrameCaptureGroupSettings.Builder)FrameCaptureGroupSettings.builder().applyMutation(frameCaptureGroupSettings)).build());
        }

        public Builder hlsGroupSettings(HlsGroupSettings var1);

        default public Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return this.hlsGroupSettings((HlsGroupSettings)((HlsGroupSettings.Builder)HlsGroupSettings.builder().applyMutation(hlsGroupSettings)).build());
        }

        public Builder mediaPackageGroupSettings(MediaPackageGroupSettings var1);

        default public Builder mediaPackageGroupSettings(Consumer<MediaPackageGroupSettings.Builder> mediaPackageGroupSettings) {
            return this.mediaPackageGroupSettings((MediaPackageGroupSettings)((MediaPackageGroupSettings.Builder)MediaPackageGroupSettings.builder().applyMutation(mediaPackageGroupSettings)).build());
        }

        public Builder msSmoothGroupSettings(MsSmoothGroupSettings var1);

        default public Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return this.msSmoothGroupSettings((MsSmoothGroupSettings)((MsSmoothGroupSettings.Builder)MsSmoothGroupSettings.builder().applyMutation(msSmoothGroupSettings)).build());
        }

        public Builder multiplexGroupSettings(MultiplexGroupSettings var1);

        default public Builder multiplexGroupSettings(Consumer<MultiplexGroupSettings.Builder> multiplexGroupSettings) {
            return this.multiplexGroupSettings((MultiplexGroupSettings)((MultiplexGroupSettings.Builder)MultiplexGroupSettings.builder().applyMutation(multiplexGroupSettings)).build());
        }

        public Builder rtmpGroupSettings(RtmpGroupSettings var1);

        default public Builder rtmpGroupSettings(Consumer<RtmpGroupSettings.Builder> rtmpGroupSettings) {
            return this.rtmpGroupSettings((RtmpGroupSettings)((RtmpGroupSettings.Builder)RtmpGroupSettings.builder().applyMutation(rtmpGroupSettings)).build());
        }

        public Builder udpGroupSettings(UdpGroupSettings var1);

        default public Builder udpGroupSettings(Consumer<UdpGroupSettings.Builder> udpGroupSettings) {
            return this.udpGroupSettings((UdpGroupSettings)((UdpGroupSettings.Builder)UdpGroupSettings.builder().applyMutation(udpGroupSettings)).build());
        }
    }
}

