/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.CdiInputSpecification;
import software.amazon.awssdk.services.medialive.model.ChannelClass;
import software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint;
import software.amazon.awssdk.services.medialive.model.ChannelState;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.InputSpecification;
import software.amazon.awssdk.services.medialive.model.LogLevel;
import software.amazon.awssdk.services.medialive.model.MaintenanceStatus;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.PipelineDetail;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.VpcOutputSettingsDescription;
import software.amazon.awssdk.services.medialive.model.___listOfChannelEgressEndpointCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.___listOfPipelineDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopChannelResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, StopChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StopChannelResponse.getter(StopChannelResponse::arn)).setter(StopChannelResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdiInputSpecification").getter(StopChannelResponse.getter(StopChannelResponse::cdiInputSpecification)).setter(StopChannelResponse.setter(Builder::cdiInputSpecification)).constructor(CdiInputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build()}).build();
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelClass").getter(StopChannelResponse.getter(StopChannelResponse::channelClassAsString)).setter(StopChannelResponse.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(StopChannelResponse.getter(StopChannelResponse::destinations)).setter(StopChannelResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ChannelEgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressEndpoints").getter(StopChannelResponse.getter(StopChannelResponse::egressEndpoints)).setter(StopChannelResponse.setter(Builder::egressEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelEgressEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncoderSettings").getter(StopChannelResponse.getter(StopChannelResponse::encoderSettings)).setter(StopChannelResponse.setter(Builder::encoderSettings)).constructor(EncoderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StopChannelResponse.getter(StopChannelResponse::id)).setter(StopChannelResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputAttachments").getter(StopChannelResponse.getter(StopChannelResponse::inputAttachments)).setter(StopChannelResponse.setter(Builder::inputAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSpecification").getter(StopChannelResponse.getter(StopChannelResponse::inputSpecification)).setter(StopChannelResponse.setter(Builder::inputSpecification)).constructor(InputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(StopChannelResponse.getter(StopChannelResponse::logLevelAsString)).setter(StopChannelResponse.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<MaintenanceStatus> MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Maintenance").getter(StopChannelResponse.getter(StopChannelResponse::maintenance)).setter(StopChannelResponse.setter(Builder::maintenance)).constructor(MaintenanceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StopChannelResponse.getter(StopChannelResponse::name)).setter(StopChannelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<PipelineDetail>> PIPELINE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineDetails").getter(StopChannelResponse.getter(StopChannelResponse::pipelineDetails)).setter(StopChannelResponse.setter(Builder::pipelineDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PipelinesRunningCount").getter(StopChannelResponse.getter(StopChannelResponse::pipelinesRunningCount)).setter(StopChannelResponse.setter(Builder::pipelinesRunningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(StopChannelResponse.getter(StopChannelResponse::roleArn)).setter(StopChannelResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StopChannelResponse.getter(StopChannelResponse::stateAsString)).setter(StopChannelResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StopChannelResponse.getter(StopChannelResponse::tags)).setter(StopChannelResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VpcOutputSettingsDescription> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(StopChannelResponse.getter(StopChannelResponse::vpc)).setter(StopChannelResponse.setter(Builder::vpc)).constructor(VpcOutputSettingsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CDI_INPUT_SPECIFICATION_FIELD, CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, EGRESS_ENDPOINTS_FIELD, ENCODER_SETTINGS_FIELD, ID_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, MAINTENANCE_FIELD, NAME_FIELD, PIPELINE_DETAILS_FIELD, PIPELINES_RUNNING_COUNT_FIELD, ROLE_ARN_FIELD, STATE_FIELD, TAGS_FIELD, VPC_FIELD));
    private final String arn;
    private final CdiInputSpecification cdiInputSpecification;
    private final String channelClass;
    private final List<OutputDestination> destinations;
    private final List<ChannelEgressEndpoint> egressEndpoints;
    private final EncoderSettings encoderSettings;
    private final String id;
    private final List<InputAttachment> inputAttachments;
    private final InputSpecification inputSpecification;
    private final String logLevel;
    private final MaintenanceStatus maintenance;
    private final String name;
    private final List<PipelineDetail> pipelineDetails;
    private final Integer pipelinesRunningCount;
    private final String roleArn;
    private final String state;
    private final Map<String, String> tags;
    private final VpcOutputSettingsDescription vpc;

    private StopChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.encoderSettings = builder.encoderSettings;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.maintenance = builder.maintenance;
        this.name = builder.name;
        this.pipelineDetails = builder.pipelineDetails;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpc = builder.vpc;
    }

    public final String arn() {
        return this.arn;
    }

    public final CdiInputSpecification cdiInputSpecification() {
        return this.cdiInputSpecification;
    }

    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(this.channelClass);
    }

    public final String channelClassAsString() {
        return this.channelClass;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<OutputDestination> destinations() {
        return this.destinations;
    }

    public final boolean hasEgressEndpoints() {
        return this.egressEndpoints != null && !(this.egressEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ChannelEgressEndpoint> egressEndpoints() {
        return this.egressEndpoints;
    }

    public final EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasInputAttachments() {
        return this.inputAttachments != null && !(this.inputAttachments instanceof SdkAutoConstructList);
    }

    public final List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public final InputSpecification inputSpecification() {
        return this.inputSpecification;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final MaintenanceStatus maintenance() {
        return this.maintenance;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPipelineDetails() {
        return this.pipelineDetails != null && !(this.pipelineDetails instanceof SdkAutoConstructList);
    }

    public final List<PipelineDetail> pipelineDetails() {
        return this.pipelineDetails;
    }

    public final Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ChannelState state() {
        return ChannelState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VpcOutputSettingsDescription vpc() {
        return this.vpc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressEndpoints() ? this.egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputAttachments() ? this.inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineDetails() ? this.pipelineDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopChannelResponse)) {
            return false;
        }
        StopChannelResponse other = (StopChannelResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cdiInputSpecification(), other.cdiInputSpecification()) && Objects.equals(this.channelClassAsString(), other.channelClassAsString()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasEgressEndpoints() == other.hasEgressEndpoints() && Objects.equals(this.egressEndpoints(), other.egressEndpoints()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && Objects.equals(this.id(), other.id()) && this.hasInputAttachments() == other.hasInputAttachments() && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.inputSpecification(), other.inputSpecification()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.maintenance(), other.maintenance()) && Objects.equals(this.name(), other.name()) && this.hasPipelineDetails() == other.hasPipelineDetails() && Objects.equals(this.pipelineDetails(), other.pipelineDetails()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpc(), other.vpc());
    }

    public final String toString() {
        return ToString.builder((String)"StopChannelResponse").add("Arn", (Object)this.arn()).add("CdiInputSpecification", (Object)this.cdiInputSpecification()).add("ChannelClass", (Object)this.channelClassAsString()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("EgressEndpoints", this.hasEgressEndpoints() ? this.egressEndpoints() : null).add("EncoderSettings", (Object)this.encoderSettings()).add("Id", (Object)this.id()).add("InputAttachments", this.hasInputAttachments() ? this.inputAttachments() : null).add("InputSpecification", (Object)this.inputSpecification()).add("LogLevel", (Object)this.logLevelAsString()).add("Maintenance", (Object)this.maintenance()).add("Name", (Object)this.name()).add("PipelineDetails", this.hasPipelineDetails() ? this.pipelineDetails() : null).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Vpc", (Object)this.vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CdiInputSpecification": {
                return Optional.ofNullable(clazz.cast(this.cdiInputSpecification()));
            }
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClassAsString()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EgressEndpoints": {
                return Optional.ofNullable(clazz.cast(this.egressEndpoints()));
            }
            case "EncoderSettings": {
                return Optional.ofNullable(clazz.cast(this.encoderSettings()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InputAttachments": {
                return Optional.ofNullable(clazz.cast(this.inputAttachments()));
            }
            case "InputSpecification": {
                return Optional.ofNullable(clazz.cast(this.inputSpecification()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Maintenance": {
                return Optional.ofNullable(clazz.cast(this.maintenance()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PipelineDetails": {
                return Optional.ofNullable(clazz.cast(this.pipelineDetails()));
            }
            case "PipelinesRunningCount": {
                return Optional.ofNullable(clazz.cast(this.pipelinesRunningCount()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopChannelResponse, T> g) {
        return obj -> g.apply((StopChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private CdiInputSpecification cdiInputSpecification;
        private String channelClass;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private List<ChannelEgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();
        private EncoderSettings encoderSettings;
        private String id;
        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();
        private InputSpecification inputSpecification;
        private String logLevel;
        private MaintenanceStatus maintenance;
        private String name;
        private List<PipelineDetail> pipelineDetails = DefaultSdkAutoConstructList.getInstance();
        private Integer pipelinesRunningCount;
        private String roleArn;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VpcOutputSettingsDescription vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(StopChannelResponse model) {
            super(model);
            this.arn(model.arn);
            this.cdiInputSpecification(model.cdiInputSpecification);
            this.channelClass(model.channelClass);
            this.destinations(model.destinations);
            this.egressEndpoints(model.egressEndpoints);
            this.encoderSettings(model.encoderSettings);
            this.id(model.id);
            this.inputAttachments(model.inputAttachments);
            this.inputSpecification(model.inputSpecification);
            this.logLevel(model.logLevel);
            this.maintenance(model.maintenance);
            this.name(model.name);
            this.pipelineDetails(model.pipelineDetails);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.roleArn(model.roleArn);
            this.state(model.state);
            this.tags(model.tags);
            this.vpc(model.vpc);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return this.cdiInputSpecification != null ? this.cdiInputSpecification.toBuilder() : null;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final String getChannelClass() {
            return this.channelClass;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        @Override
        @Transient
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        @Transient
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        @Transient
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            List<ChannelEgressEndpoint.Builder> result = ___listOfChannelEgressEndpointCopier.copyToBuilder(this.egressEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        @Override
        @Transient
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint ... egressEndpoints) {
            this.egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... egressEndpoints) {
            this.egressEndpoints(Stream.of(egressEndpoints).map(c -> (ChannelEgressEndpoint)((ChannelEgressEndpoint.Builder)ChannelEgressEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        @Override
        @Transient
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InputSpecification.Builder getInputSpecification() {
            return this.inputSpecification != null ? this.inputSpecification.toBuilder() : null;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        @Transient
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        @Transient
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final MaintenanceStatus.Builder getMaintenance() {
            return this.maintenance != null ? this.maintenance.toBuilder() : null;
        }

        public final void setMaintenance(MaintenanceStatus.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        @Transient
        public final Builder maintenance(MaintenanceStatus maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PipelineDetail.Builder> getPipelineDetails() {
            List<PipelineDetail.Builder> result = ___listOfPipelineDetailCopier.copyToBuilder(this.pipelineDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineDetails(Collection<PipelineDetail.BuilderImpl> pipelineDetails) {
            this.pipelineDetails = ___listOfPipelineDetailCopier.copyFromBuilder(pipelineDetails);
        }

        @Override
        @Transient
        public final Builder pipelineDetails(Collection<PipelineDetail> pipelineDetails) {
            this.pipelineDetails = ___listOfPipelineDetailCopier.copy(pipelineDetails);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineDetails(PipelineDetail ... pipelineDetails) {
            this.pipelineDetails(Arrays.asList(pipelineDetails));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pipelineDetails(Consumer<PipelineDetail.Builder> ... pipelineDetails) {
            this.pipelineDetails(Stream.of(pipelineDetails).map(c -> (PipelineDetail)((PipelineDetail.Builder)PipelineDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        @Override
        @Transient
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(ChannelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final VpcOutputSettingsDescription.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(VpcOutputSettingsDescription.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        @Transient
        public final Builder vpc(VpcOutputSettingsDescription vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public StopChannelResponse build() {
            return new StopChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopChannelResponse> {
        public Builder arn(String var1);

        public Builder cdiInputSpecification(CdiInputSpecification var1);

        default public Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return this.cdiInputSpecification((CdiInputSpecification)((CdiInputSpecification.Builder)CdiInputSpecification.builder().applyMutation(cdiInputSpecification)).build());
        }

        public Builder channelClass(String var1);

        public Builder channelClass(ChannelClass var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder egressEndpoints(Collection<ChannelEgressEndpoint> var1);

        public Builder egressEndpoints(ChannelEgressEndpoint ... var1);

        public Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().applyMutation(encoderSettings)).build());
        }

        public Builder id(String var1);

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder inputSpecification(InputSpecification var1);

        default public Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return this.inputSpecification((InputSpecification)((InputSpecification.Builder)InputSpecification.builder().applyMutation(inputSpecification)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder maintenance(MaintenanceStatus var1);

        default public Builder maintenance(Consumer<MaintenanceStatus.Builder> maintenance) {
            return this.maintenance((MaintenanceStatus)((MaintenanceStatus.Builder)MaintenanceStatus.builder().applyMutation(maintenance)).build());
        }

        public Builder name(String var1);

        public Builder pipelineDetails(Collection<PipelineDetail> var1);

        public Builder pipelineDetails(PipelineDetail ... var1);

        public Builder pipelineDetails(Consumer<PipelineDetail.Builder> ... var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder roleArn(String var1);

        public Builder state(String var1);

        public Builder state(ChannelState var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpc(VpcOutputSettingsDescription var1);

        default public Builder vpc(Consumer<VpcOutputSettingsDescription.Builder> vpc) {
            return this.vpc((VpcOutputSettingsDescription)((VpcOutputSettingsDescription.Builder)VpcOutputSettingsDescription.builder().applyMutation(vpc)).build());
        }
    }
}

