/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AuthenticationScheme;
import software.amazon.awssdk.services.medialive.model.InputLossActionForRtmpOut;
import software.amazon.awssdk.services.medialive.model.RtmpAdMarkers;
import software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior;
import software.amazon.awssdk.services.medialive.model.RtmpCaptionData;
import software.amazon.awssdk.services.medialive.model.___listOfRtmpAdMarkersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RtmpGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RtmpGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdMarkers").getter(RtmpGroupSettings.getter(RtmpGroupSettings::adMarkersAsStrings)).setter(RtmpGroupSettings.setter(Builder::adMarkersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTHENTICATION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationScheme").getter(RtmpGroupSettings.getter(RtmpGroupSettings::authenticationSchemeAsString)).setter(RtmpGroupSettings.setter(Builder::authenticationScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationScheme").build()}).build();
    private static final SdkField<String> CACHE_FULL_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheFullBehavior").getter(RtmpGroupSettings.getter(RtmpGroupSettings::cacheFullBehaviorAsString)).setter(RtmpGroupSettings.setter(Builder::cacheFullBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheFullBehavior").build()}).build();
    private static final SdkField<Integer> CACHE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CacheLength").getter(RtmpGroupSettings.getter(RtmpGroupSettings::cacheLength)).setter(RtmpGroupSettings.setter(Builder::cacheLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheLength").build()}).build();
    private static final SdkField<String> CAPTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionData").getter(RtmpGroupSettings.getter(RtmpGroupSettings::captionDataAsString)).setter(RtmpGroupSettings.setter(Builder::captionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionData").build()}).build();
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLossAction").getter(RtmpGroupSettings.getter(RtmpGroupSettings::inputLossActionAsString)).setter(RtmpGroupSettings.setter(Builder::inputLossAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()}).build();
    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RestartDelay").getter(RtmpGroupSettings.getter(RtmpGroupSettings::restartDelay)).setter(RtmpGroupSettings.setter(Builder::restartDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD, AUTHENTICATION_SCHEME_FIELD, CACHE_FULL_BEHAVIOR_FIELD, CACHE_LENGTH_FIELD, CAPTION_DATA_FIELD, INPUT_LOSS_ACTION_FIELD, RESTART_DELAY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> adMarkers;
    private final String authenticationScheme;
    private final String cacheFullBehavior;
    private final Integer cacheLength;
    private final String captionData;
    private final String inputLossAction;
    private final Integer restartDelay;

    private RtmpGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.authenticationScheme = builder.authenticationScheme;
        this.cacheFullBehavior = builder.cacheFullBehavior;
        this.cacheLength = builder.cacheLength;
        this.captionData = builder.captionData;
        this.inputLossAction = builder.inputLossAction;
        this.restartDelay = builder.restartDelay;
    }

    public final List<RtmpAdMarkers> adMarkers() {
        return ___listOfRtmpAdMarkersCopier.copyStringToEnum(this.adMarkers);
    }

    public final boolean hasAdMarkers() {
        return this.adMarkers != null && !(this.adMarkers instanceof SdkAutoConstructList);
    }

    public final List<String> adMarkersAsStrings() {
        return this.adMarkers;
    }

    public final AuthenticationScheme authenticationScheme() {
        return AuthenticationScheme.fromValue(this.authenticationScheme);
    }

    public final String authenticationSchemeAsString() {
        return this.authenticationScheme;
    }

    public final RtmpCacheFullBehavior cacheFullBehavior() {
        return RtmpCacheFullBehavior.fromValue(this.cacheFullBehavior);
    }

    public final String cacheFullBehaviorAsString() {
        return this.cacheFullBehavior;
    }

    public final Integer cacheLength() {
        return this.cacheLength;
    }

    public final RtmpCaptionData captionData() {
        return RtmpCaptionData.fromValue(this.captionData);
    }

    public final String captionDataAsString() {
        return this.captionData;
    }

    public final InputLossActionForRtmpOut inputLossAction() {
        return InputLossActionForRtmpOut.fromValue(this.inputLossAction);
    }

    public final String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public final Integer restartDelay() {
        return this.restartDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdMarkers() ? this.adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheFullBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtmpGroupSettings)) {
            return false;
        }
        RtmpGroupSettings other = (RtmpGroupSettings)obj;
        return this.hasAdMarkers() == other.hasAdMarkers() && Objects.equals(this.adMarkersAsStrings(), other.adMarkersAsStrings()) && Objects.equals(this.authenticationSchemeAsString(), other.authenticationSchemeAsString()) && Objects.equals(this.cacheFullBehaviorAsString(), other.cacheFullBehaviorAsString()) && Objects.equals(this.cacheLength(), other.cacheLength()) && Objects.equals(this.captionDataAsString(), other.captionDataAsString()) && Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.restartDelay(), other.restartDelay());
    }

    public final String toString() {
        return ToString.builder((String)"RtmpGroupSettings").add("AdMarkers", this.hasAdMarkers() ? this.adMarkersAsStrings() : null).add("AuthenticationScheme", (Object)this.authenticationSchemeAsString()).add("CacheFullBehavior", (Object)this.cacheFullBehaviorAsString()).add("CacheLength", (Object)this.cacheLength()).add("CaptionData", (Object)this.captionDataAsString()).add("InputLossAction", (Object)this.inputLossActionAsString()).add("RestartDelay", (Object)this.restartDelay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdMarkers": {
                return Optional.ofNullable(clazz.cast(this.adMarkersAsStrings()));
            }
            case "AuthenticationScheme": {
                return Optional.ofNullable(clazz.cast(this.authenticationSchemeAsString()));
            }
            case "CacheFullBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheFullBehaviorAsString()));
            }
            case "CacheLength": {
                return Optional.ofNullable(clazz.cast(this.cacheLength()));
            }
            case "CaptionData": {
                return Optional.ofNullable(clazz.cast(this.captionDataAsString()));
            }
            case "InputLossAction": {
                return Optional.ofNullable(clazz.cast(this.inputLossActionAsString()));
            }
            case "RestartDelay": {
                return Optional.ofNullable(clazz.cast(this.restartDelay()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RtmpGroupSettings, T> g) {
        return obj -> g.apply((RtmpGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();
        private String authenticationScheme;
        private String cacheFullBehavior;
        private Integer cacheLength;
        private String captionData;
        private String inputLossAction;
        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(RtmpGroupSettings model) {
            this.adMarkersWithStrings(model.adMarkers);
            this.authenticationScheme(model.authenticationScheme);
            this.cacheFullBehavior(model.cacheFullBehavior);
            this.cacheLength(model.cacheLength);
            this.captionData(model.captionData);
            this.inputLossAction(model.inputLossAction);
            this.restartDelay(model.restartDelay);
        }

        public final Collection<String> getAdMarkers() {
            if (this.adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adMarkers;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copy(adMarkers);
        }

        @Override
        @Transient
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkersWithStrings(String ... adMarkers) {
            this.adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        @Transient
        public final Builder adMarkers(Collection<RtmpAdMarkers> adMarkers) {
            this.adMarkers = ___listOfRtmpAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder adMarkers(RtmpAdMarkers ... adMarkers) {
            this.adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final String getAuthenticationScheme() {
            return this.authenticationScheme;
        }

        public final void setAuthenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
        }

        @Override
        @Transient
        public final Builder authenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        @Override
        @Transient
        public final Builder authenticationScheme(AuthenticationScheme authenticationScheme) {
            this.authenticationScheme(authenticationScheme == null ? null : authenticationScheme.toString());
            return this;
        }

        public final String getCacheFullBehavior() {
            return this.cacheFullBehavior;
        }

        public final void setCacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
        }

        @Override
        @Transient
        public final Builder cacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder cacheFullBehavior(RtmpCacheFullBehavior cacheFullBehavior) {
            this.cacheFullBehavior(cacheFullBehavior == null ? null : cacheFullBehavior.toString());
            return this;
        }

        public final Integer getCacheLength() {
            return this.cacheLength;
        }

        public final void setCacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
        }

        @Override
        @Transient
        public final Builder cacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
            return this;
        }

        public final String getCaptionData() {
            return this.captionData;
        }

        public final void setCaptionData(String captionData) {
            this.captionData = captionData;
        }

        @Override
        @Transient
        public final Builder captionData(String captionData) {
            this.captionData = captionData;
            return this;
        }

        @Override
        @Transient
        public final Builder captionData(RtmpCaptionData captionData) {
            this.captionData(captionData == null ? null : captionData.toString());
            return this;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        @Override
        @Transient
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        @Transient
        public final Builder inputLossAction(InputLossActionForRtmpOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        @Transient
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public RtmpGroupSettings build() {
            return new RtmpGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RtmpGroupSettings> {
        public Builder adMarkersWithStrings(Collection<String> var1);

        public Builder adMarkersWithStrings(String ... var1);

        public Builder adMarkers(Collection<RtmpAdMarkers> var1);

        public Builder adMarkers(RtmpAdMarkers ... var1);

        public Builder authenticationScheme(String var1);

        public Builder authenticationScheme(AuthenticationScheme var1);

        public Builder cacheFullBehavior(String var1);

        public Builder cacheFullBehavior(RtmpCacheFullBehavior var1);

        public Builder cacheLength(Integer var1);

        public Builder captionData(String var1);

        public Builder captionData(RtmpCaptionData var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForRtmpOut var1);

        public Builder restartDelay(Integer var1);
    }
}

