/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReservationCodec {
    MPEG2("MPEG2"),
    AVC("AVC"),
    HEVC("HEVC"),
    AUDIO("AUDIO"),
    LINK("LINK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReservationCodec> VALUE_MAP;
    private final String value;

    private ReservationCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReservationCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReservationCodec> knownValues() {
        EnumSet<ReservationCodec> knownValues = EnumSet.allOf(ReservationCodec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReservationCodec.class, ReservationCodec::toString);
    }
}

