/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AacCodingMode;
import software.amazon.awssdk.services.medialive.model.AacInputType;
import software.amazon.awssdk.services.medialive.model.AacProfile;
import software.amazon.awssdk.services.medialive.model.AacRateControlMode;
import software.amazon.awssdk.services.medialive.model.AacRawFormat;
import software.amazon.awssdk.services.medialive.model.AacSpec;
import software.amazon.awssdk.services.medialive.model.AacVbrQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AacSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AacSettings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Bitrate").getter(AacSettings.getter(AacSettings::bitrate)).setter(AacSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(AacSettings.getter(AacSettings::codingModeAsString)).setter(AacSettings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputType").getter(AacSettings.getter(AacSettings::inputTypeAsString)).setter(AacSettings.setter(Builder::inputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(AacSettings.getter(AacSettings::profileAsString)).setter(AacSettings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(AacSettings.getter(AacSettings::rateControlModeAsString)).setter(AacSettings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> RAW_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RawFormat").getter(AacSettings.getter(AacSettings::rawFormatAsString)).setter(AacSettings.setter(Builder::rawFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawFormat").build()}).build();
    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleRate").getter(AacSettings.getter(AacSettings::sampleRate)).setter(AacSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<String> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Spec").getter(AacSettings.getter(AacSettings::specAsString)).setter(AacSettings.setter(Builder::spec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> VBR_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VbrQuality").getter(AacSettings.getter(AacSettings::vbrQualityAsString)).setter(AacSettings.setter(Builder::vbrQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CODING_MODE_FIELD, INPUT_TYPE_FIELD, PROFILE_FIELD, RATE_CONTROL_MODE_FIELD, RAW_FORMAT_FIELD, SAMPLE_RATE_FIELD, SPEC_FIELD, VBR_QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double bitrate;
    private final String codingMode;
    private final String inputType;
    private final String profile;
    private final String rateControlMode;
    private final String rawFormat;
    private final Double sampleRate;
    private final String spec;
    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.inputType = builder.inputType;
        this.profile = builder.profile;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.spec = builder.spec;
        this.vbrQuality = builder.vbrQuality;
    }

    public final Double bitrate() {
        return this.bitrate;
    }

    public final AacCodingMode codingMode() {
        return AacCodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final AacInputType inputType() {
        return AacInputType.fromValue(this.inputType);
    }

    public final String inputTypeAsString() {
        return this.inputType;
    }

    public final AacProfile profile() {
        return AacProfile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(this.rawFormat);
    }

    public final String rawFormatAsString() {
        return this.rawFormat;
    }

    public final Double sampleRate() {
        return this.sampleRate;
    }

    public final AacSpec spec() {
        return AacSpec.fromValue(this.spec);
    }

    public final String specAsString() {
        return this.spec;
    }

    public final AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(this.vbrQuality);
    }

    public final String vbrQualityAsString() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.specAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQualityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.inputTypeAsString(), other.inputTypeAsString()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.rawFormatAsString(), other.rawFormatAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.specAsString(), other.specAsString()) && Objects.equals(this.vbrQualityAsString(), other.vbrQualityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AacSettings").add("Bitrate", (Object)this.bitrate()).add("CodingMode", (Object)this.codingModeAsString()).add("InputType", (Object)this.inputTypeAsString()).add("Profile", (Object)this.profileAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("RawFormat", (Object)this.rawFormatAsString()).add("SampleRate", (Object)this.sampleRate()).add("Spec", (Object)this.specAsString()).add("VbrQuality", (Object)this.vbrQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "InputType": {
                return Optional.ofNullable(clazz.cast(this.inputTypeAsString()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "RawFormat": {
                return Optional.ofNullable(clazz.cast(this.rawFormatAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "Spec": {
                return Optional.ofNullable(clazz.cast(this.specAsString()));
            }
            case "VbrQuality": {
                return Optional.ofNullable(clazz.cast(this.vbrQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AacSettings, T> g) {
        return obj -> g.apply((AacSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bitrate;
        private String codingMode;
        private String inputType;
        private String profile;
        private String rateControlMode;
        private String rawFormat;
        private Double sampleRate;
        private String spec;
        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            this.bitrate(model.bitrate);
            this.codingMode(model.codingMode);
            this.inputType(model.inputType);
            this.profile(model.profile);
            this.rateControlMode(model.rateControlMode);
            this.rawFormat(model.rawFormat);
            this.sampleRate(model.sampleRate);
            this.spec(model.spec);
            this.vbrQuality(model.vbrQuality);
        }

        public final Double getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        @Transient
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getInputType() {
            return this.inputType;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        @Transient
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        @Transient
        public final Builder inputType(AacInputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        @Transient
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        @Transient
        public final Builder profile(AacProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        @Transient
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        @Transient
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getRawFormat() {
            return this.rawFormat;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        @Override
        @Transient
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat == null ? null : rawFormat.toString());
            return this;
        }

        public final Double getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        @Transient
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final String getSpec() {
            return this.spec;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        @Override
        @Transient
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        @Override
        @Transient
        public final Builder spec(AacSpec spec) {
            this.spec(spec == null ? null : spec.toString());
            return this;
        }

        public final String getVbrQuality() {
            return this.vbrQuality;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        @Transient
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        @Transient
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality == null ? null : vbrQuality.toString());
            return this;
        }

        public AacSettings build() {
            return new AacSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AacSettings> {
        public Builder bitrate(Double var1);

        public Builder codingMode(String var1);

        public Builder codingMode(AacCodingMode var1);

        public Builder inputType(String var1);

        public Builder inputType(AacInputType var1);

        public Builder profile(String var1);

        public Builder profile(AacProfile var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(AacRateControlMode var1);

        public Builder rawFormat(String var1);

        public Builder rawFormat(AacRawFormat var1);

        public Builder sampleRate(Double var1);

        public Builder spec(String var1);

        public Builder spec(AacSpec var1);

        public Builder vbrQuality(String var1);

        public Builder vbrQuality(AacVbrQuality var1);
    }
}

