/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReservationRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateReservationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateReservationRequest.getter(UpdateReservationRequest::name)).setter(UpdateReservationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationId").getter(UpdateReservationRequest.getter(UpdateReservationRequest::reservationId)).setter(UpdateReservationRequest.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("reservationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RESERVATION_ID_FIELD));
    private final String name;
    private final String reservationId;

    private UpdateReservationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.reservationId = builder.reservationId;
    }

    public final String name() {
        return this.name;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReservationRequest)) {
            return false;
        }
        UpdateReservationRequest other = (UpdateReservationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.reservationId(), other.reservationId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReservationRequest").add("Name", (Object)this.name()).add("ReservationId", (Object)this.reservationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReservationRequest, T> g) {
        return obj -> g.apply((UpdateReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String name;
        private String reservationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReservationRequest model) {
            super(model);
            this.name(model.name);
            this.reservationId(model.reservationId);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        @Transient
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReservationRequest build() {
            return new UpdateReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReservationRequest> {
        public Builder name(String var1);

        public Builder reservationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

