/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AfdSignaling;
import software.amazon.awssdk.services.medialive.model.FixedAfd;
import software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization;
import software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata;
import software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace;
import software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio;
import software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings;
import software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits;
import software.amazon.awssdk.services.medialive.model.Mpeg2ScanType;
import software.amazon.awssdk.services.medialive.model.Mpeg2SubGopLength;
import software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mpeg2Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mpeg2Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(Mpeg2Settings.getter(Mpeg2Settings::adaptiveQuantizationAsString)).setter(Mpeg2Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(Mpeg2Settings.getter(Mpeg2Settings::afdSignalingAsString)).setter(Mpeg2Settings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorMetadata").getter(Mpeg2Settings.getter(Mpeg2Settings::colorMetadataAsString)).setter(Mpeg2Settings.setter(Builder::colorMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()}).build();
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpace").getter(Mpeg2Settings.getter(Mpeg2Settings::colorSpaceAsString)).setter(Mpeg2Settings.setter(Builder::colorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()}).build();
    private static final SdkField<String> DISPLAY_ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayAspectRatio").getter(Mpeg2Settings.getter(Mpeg2Settings::displayAspectRatioAsString)).setter(Mpeg2Settings.setter(Builder::displayAspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayAspectRatio").build()}).build();
    private static final SdkField<Mpeg2FilterSettings> FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterSettings").getter(Mpeg2Settings.getter(Mpeg2Settings::filterSettings)).setter(Mpeg2Settings.setter(Builder::filterSettings)).constructor(Mpeg2FilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()}).build();
    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedAfd").getter(Mpeg2Settings.getter(Mpeg2Settings::fixedAfdAsString)).setter(Mpeg2Settings.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateDenominator)).setter(Mpeg2Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateNumerator)).setter(Mpeg2Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(Mpeg2Settings.getter(Mpeg2Settings::gopClosedCadence)).setter(Mpeg2Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Integer> GOP_NUM_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopNumBFrames").getter(Mpeg2Settings.getter(Mpeg2Settings::gopNumBFrames)).setter(Mpeg2Settings.setter(Builder::gopNumBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopNumBFrames").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(Mpeg2Settings.getter(Mpeg2Settings::gopSize)).setter(Mpeg2Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(Mpeg2Settings.getter(Mpeg2Settings::gopSizeUnitsAsString)).setter(Mpeg2Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(Mpeg2Settings.getter(Mpeg2Settings::scanTypeAsString)).setter(Mpeg2Settings.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> SUBGOP_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubgopLength").getter(Mpeg2Settings.getter(Mpeg2Settings::subgopLengthAsString)).setter(Mpeg2Settings.setter(Builder::subgopLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subgopLength").build()}).build();
    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeInsertion").getter(Mpeg2Settings.getter(Mpeg2Settings::timecodeInsertionAsString)).setter(Mpeg2Settings.setter(Builder::timecodeInsertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, AFD_SIGNALING_FIELD, COLOR_METADATA_FIELD, COLOR_SPACE_FIELD, DISPLAY_ASPECT_RATIO_FIELD, FILTER_SETTINGS_FIELD, FIXED_AFD_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_NUM_B_FRAMES_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, SCAN_TYPE_FIELD, SUBGOP_LENGTH_FIELD, TIMECODE_INSERTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String afdSignaling;
    private final String colorMetadata;
    private final String colorSpace;
    private final String displayAspectRatio;
    private final Mpeg2FilterSettings filterSettings;
    private final String fixedAfd;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer gopClosedCadence;
    private final Integer gopNumBFrames;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final String scanType;
    private final String subgopLength;
    private final String timecodeInsertion;

    private Mpeg2Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpace = builder.colorSpace;
        this.displayAspectRatio = builder.displayAspectRatio;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopNumBFrames = builder.gopNumBFrames;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.scanType = builder.scanType;
        this.subgopLength = builder.subgopLength;
        this.timecodeInsertion = builder.timecodeInsertion;
    }

    public final Mpeg2AdaptiveQuantization adaptiveQuantization() {
        return Mpeg2AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final Mpeg2ColorMetadata colorMetadata() {
        return Mpeg2ColorMetadata.fromValue(this.colorMetadata);
    }

    public final String colorMetadataAsString() {
        return this.colorMetadata;
    }

    public final Mpeg2ColorSpace colorSpace() {
        return Mpeg2ColorSpace.fromValue(this.colorSpace);
    }

    public final String colorSpaceAsString() {
        return this.colorSpace;
    }

    public final Mpeg2DisplayRatio displayAspectRatio() {
        return Mpeg2DisplayRatio.fromValue(this.displayAspectRatio);
    }

    public final String displayAspectRatioAsString() {
        return this.displayAspectRatio;
    }

    public final Mpeg2FilterSettings filterSettings() {
        return this.filterSettings;
    }

    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(this.fixedAfd);
    }

    public final String fixedAfdAsString() {
        return this.fixedAfd;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Integer gopNumBFrames() {
        return this.gopNumBFrames;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final Mpeg2GopSizeUnits gopSizeUnits() {
        return Mpeg2GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final Mpeg2ScanType scanType() {
        return Mpeg2ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final Mpeg2SubGopLength subgopLength() {
        return Mpeg2SubGopLength.fromValue(this.subgopLength);
    }

    public final String subgopLengthAsString() {
        return this.subgopLength;
    }

    public final Mpeg2TimecodeInsertionBehavior timecodeInsertion() {
        return Mpeg2TimecodeInsertionBehavior.fromValue(this.timecodeInsertion);
    }

    public final String timecodeInsertionAsString() {
        return this.timecodeInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayAspectRatioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopNumBFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subgopLengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mpeg2Settings)) {
            return false;
        }
        Mpeg2Settings other = (Mpeg2Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.displayAspectRatioAsString(), other.displayAspectRatioAsString()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.fixedAfdAsString(), other.fixedAfdAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopNumBFrames(), other.gopNumBFrames()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.subgopLengthAsString(), other.subgopLengthAsString()) && Objects.equals(this.timecodeInsertionAsString(), other.timecodeInsertionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Mpeg2Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AfdSignaling", (Object)this.afdSignalingAsString()).add("ColorMetadata", (Object)this.colorMetadataAsString()).add("ColorSpace", (Object)this.colorSpaceAsString()).add("DisplayAspectRatio", (Object)this.displayAspectRatioAsString()).add("FilterSettings", (Object)this.filterSettings()).add("FixedAfd", (Object)this.fixedAfdAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopNumBFrames", (Object)this.gopNumBFrames()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("SubgopLength", (Object)this.subgopLengthAsString()).add("TimecodeInsertion", (Object)this.timecodeInsertionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "ColorMetadata": {
                return Optional.ofNullable(clazz.cast(this.colorMetadataAsString()));
            }
            case "ColorSpace": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceAsString()));
            }
            case "DisplayAspectRatio": {
                return Optional.ofNullable(clazz.cast(this.displayAspectRatioAsString()));
            }
            case "FilterSettings": {
                return Optional.ofNullable(clazz.cast(this.filterSettings()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfdAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopNumBFrames": {
                return Optional.ofNullable(clazz.cast(this.gopNumBFrames()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "SubgopLength": {
                return Optional.ofNullable(clazz.cast(this.subgopLengthAsString()));
            }
            case "TimecodeInsertion": {
                return Optional.ofNullable(clazz.cast(this.timecodeInsertionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mpeg2Settings, T> g) {
        return obj -> g.apply((Mpeg2Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String afdSignaling;
        private String colorMetadata;
        private String colorSpace;
        private String displayAspectRatio;
        private Mpeg2FilterSettings filterSettings;
        private String fixedAfd;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer gopClosedCadence;
        private Integer gopNumBFrames;
        private Double gopSize;
        private String gopSizeUnits;
        private String scanType;
        private String subgopLength;
        private String timecodeInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(Mpeg2Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.afdSignaling(model.afdSignaling);
            this.colorMetadata(model.colorMetadata);
            this.colorSpace(model.colorSpace);
            this.displayAspectRatio(model.displayAspectRatio);
            this.filterSettings(model.filterSettings);
            this.fixedAfd(model.fixedAfd);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopNumBFrames(model.gopNumBFrames);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.scanType(model.scanType);
            this.subgopLength(model.subgopLength);
            this.timecodeInsertion(model.timecodeInsertion);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        @Transient
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        @Transient
        public final Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        @Transient
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        @Transient
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        @Transient
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        @Transient
        public final Builder colorMetadata(Mpeg2ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        @Override
        @Transient
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        @Transient
        public final Builder colorSpace(Mpeg2ColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final String getDisplayAspectRatio() {
            return this.displayAspectRatio;
        }

        public final void setDisplayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
        }

        @Override
        @Transient
        public final Builder displayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
            return this;
        }

        @Override
        @Transient
        public final Builder displayAspectRatio(Mpeg2DisplayRatio displayAspectRatio) {
            this.displayAspectRatio(displayAspectRatio == null ? null : displayAspectRatio.toString());
            return this;
        }

        public final Mpeg2FilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(Mpeg2FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder filterSettings(Mpeg2FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return this.fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        @Transient
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        @Transient
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        @Transient
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        @Transient
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        @Transient
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getGopNumBFrames() {
            return this.gopNumBFrames;
        }

        public final void setGopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
        }

        @Override
        @Transient
        public final Builder gopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
            return this;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        @Transient
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        @Transient
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        @Transient
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        @Transient
        public final Builder scanType(Mpeg2ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSubgopLength() {
            return this.subgopLength;
        }

        public final void setSubgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
        }

        @Override
        @Transient
        public final Builder subgopLength(String subgopLength) {
            this.subgopLength = subgopLength;
            return this;
        }

        @Override
        @Transient
        public final Builder subgopLength(Mpeg2SubGopLength subgopLength) {
            this.subgopLength(subgopLength == null ? null : subgopLength.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        @Transient
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        @Transient
        public final Builder timecodeInsertion(Mpeg2TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public Mpeg2Settings build() {
            return new Mpeg2Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mpeg2Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(Mpeg2AdaptiveQuantization var1);

        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(Mpeg2ColorMetadata var1);

        public Builder colorSpace(String var1);

        public Builder colorSpace(Mpeg2ColorSpace var1);

        public Builder displayAspectRatio(String var1);

        public Builder displayAspectRatio(Mpeg2DisplayRatio var1);

        public Builder filterSettings(Mpeg2FilterSettings var1);

        default public Builder filterSettings(Consumer<Mpeg2FilterSettings.Builder> filterSettings) {
            return this.filterSettings((Mpeg2FilterSettings)((Mpeg2FilterSettings.Builder)Mpeg2FilterSettings.builder().applyMutation(filterSettings)).build());
        }

        public Builder fixedAfd(String var1);

        public Builder fixedAfd(FixedAfd var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopNumBFrames(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(Mpeg2GopSizeUnits var1);

        public Builder scanType(String var1);

        public Builder scanType(Mpeg2ScanType var1);

        public Builder subgopLength(String var1);

        public Builder subgopLength(Mpeg2SubGopLength var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(Mpeg2TimecodeInsertionBehavior var1);
    }
}

