/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcOutputSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcOutputSettingsDescription> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(VpcOutputSettingsDescription.getter(VpcOutputSettingsDescription::availabilityZones)).setter(VpcOutputSettingsDescription.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(VpcOutputSettingsDescription.getter(VpcOutputSettingsDescription::networkInterfaceIds)).setter(VpcOutputSettingsDescription.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VpcOutputSettingsDescription.getter(VpcOutputSettingsDescription::securityGroupIds)).setter(VpcOutputSettingsDescription.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VpcOutputSettingsDescription.getter(VpcOutputSettingsDescription::subnetIds)).setter(VpcOutputSettingsDescription.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, NETWORK_INTERFACE_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> availabilityZones;
    private final List<String> networkInterfaceIds;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;

    private VpcOutputSettingsDescription(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOutputSettingsDescription)) {
            return false;
        }
        VpcOutputSettingsDescription other = (VpcOutputSettingsDescription)obj;
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds() && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public final String toString() {
        return ToString.builder((String)"VpcOutputSettingsDescription").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("NetworkInterfaceIds", this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcOutputSettingsDescription, T> g) {
        return obj -> g.apply((VpcOutputSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOutputSettingsDescription model) {
            this.availabilityZones(model.availabilityZones);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (this.networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ___listOf__stringCopier.copy(networkInterfaceIds);
        }

        @Override
        @Transient
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = ___listOf__stringCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ___listOf__stringCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        @Transient
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public VpcOutputSettingsDescription build() {
            return new VpcOutputSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcOutputSettingsDescription> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);
    }
}

