/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update an input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInputRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateInputRequest.Builder, UpdateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField
            .<List<InputDestinationRequest>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(UpdateInputRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDestinationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDestinationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputDeviceRequest>> INPUT_DEVICES_FIELD = SdkField
            .<List<InputDeviceRequest>> builder(MarshallingType.LIST)
            .memberName("InputDevices")
            .getter(getter(UpdateInputRequest::inputDevices))
            .setter(setter(Builder::inputDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDeviceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDeviceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(UpdateInputRequest::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputId").build()).build();

    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InputSecurityGroups")
            .getter(getter(UpdateInputRequest::inputSecurityGroups))
            .setter(setter(Builder::inputSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MediaConnectFlowRequest>> MEDIA_CONNECT_FLOWS_FIELD = SdkField
            .<List<MediaConnectFlowRequest>> builder(MarshallingType.LIST)
            .memberName("MediaConnectFlows")
            .getter(getter(UpdateInputRequest::mediaConnectFlows))
            .setter(setter(Builder::mediaConnectFlows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConnectFlowRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConnectFlowRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateInputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateInputRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField
            .<List<InputSourceRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(UpdateInputRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD,
            INPUT_DEVICES_FIELD, INPUT_ID_FIELD, INPUT_SECURITY_GROUPS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD,
            ROLE_ARN_FIELD, SOURCES_FIELD));

    private final List<InputDestinationRequest> destinations;

    private final List<InputDeviceRequest> inputDevices;

    private final String inputId;

    private final List<String> inputSecurityGroups;

    private final List<MediaConnectFlowRequest> mediaConnectFlows;

    private final String name;

    private final String roleArn;

    private final List<InputSourceRequest> sources;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputDevices = builder.inputDevices;
        this.inputId = builder.inputId;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
    }

    /**
     * Returns true if the Destinations property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * Destination settings for PUSH type inputs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Destination settings for PUSH type inputs.
     */
    public final List<InputDestinationRequest> destinations() {
        return destinations;
    }

    /**
     * Returns true if the InputDevices property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputDevices() {
        return inputDevices != null && !(inputDevices instanceof SdkAutoConstructList);
    }

    /**
     * Settings for the devices.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Settings for the devices.
     */
    public final List<InputDeviceRequest> inputDevices() {
        return inputDevices;
    }

    /**
     * Unique ID of the input.
     * 
     * @return Unique ID of the input.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * Returns true if the InputSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputSecurityGroups() {
        return inputSecurityGroups != null && !(inputSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * A list of security groups referenced by IDs to attach to the input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of security groups referenced by IDs to attach to the input.
     */
    public final List<String> inputSecurityGroups() {
        return inputSecurityGroups;
    }

    /**
     * Returns true if the MediaConnectFlows property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMediaConnectFlows() {
        return mediaConnectFlows != null && !(mediaConnectFlows instanceof SdkAutoConstructList);
    }

    /**
     * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as
     * one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is
     * in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMediaConnectFlows()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as
     *         few as one Flow and presently, as many as two. The only requirement is when you have more than one is
     *         that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
     *         issues.
     */
    public final List<MediaConnectFlowRequest> mediaConnectFlows() {
        return mediaConnectFlows;
    }

    /**
     * Name of the input.
     * 
     * @return Name of the input.
     */
    public final String name() {
        return name;
    }

    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     * 
     * @return The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only
     * specify sources for PULL type Inputs. Leave Destinations empty.
     *
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
     *         redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
     */
    public final List<InputSourceRequest> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDevices() ? inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSecurityGroups() ? inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaConnectFlows() ? mediaConnectFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && hasInputDevices() == other.hasInputDevices() && Objects.equals(inputDevices(), other.inputDevices())
                && Objects.equals(inputId(), other.inputId()) && hasInputSecurityGroups() == other.hasInputSecurityGroups()
                && Objects.equals(inputSecurityGroups(), other.inputSecurityGroups())
                && hasMediaConnectFlows() == other.hasMediaConnectFlows()
                && Objects.equals(mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInputRequest").add("Destinations", hasDestinations() ? destinations() : null)
                .add("InputDevices", hasInputDevices() ? inputDevices() : null).add("InputId", inputId())
                .add("InputSecurityGroups", hasInputSecurityGroups() ? inputSecurityGroups() : null)
                .add("MediaConnectFlows", hasMediaConnectFlows() ? mediaConnectFlows() : null).add("Name", name())
                .add("RoleArn", roleArn()).add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "InputDevices":
            return Optional.ofNullable(clazz.cast(inputDevices()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputSecurityGroups":
            return Optional.ofNullable(clazz.cast(inputSecurityGroups()));
        case "MediaConnectFlows":
            return Optional.ofNullable(clazz.cast(mediaConnectFlows()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInputRequest> {
        /**
         * Destination settings for PUSH type inputs.
         * 
         * @param destinations
         *        Destination settings for PUSH type inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<InputDestinationRequest> destinations);

        /**
         * Destination settings for PUSH type inputs.
         * 
         * @param destinations
         *        Destination settings for PUSH type inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(InputDestinationRequest... destinations);

        /**
         * Destination settings for PUSH type inputs. This is a convenience that creates an instance of the {@link List
         * <InputDestinationRequest>.Builder} avoiding the need to create one manually via {@link List
         * <InputDestinationRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputDestinationRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<InputDestinationRequest>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on {@link List<InputDestinationRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(List<InputDestinationRequest>)
         */
        Builder destinations(Consumer<InputDestinationRequest.Builder>... destinations);

        /**
         * Settings for the devices.
         * 
         * @param inputDevices
         *        Settings for the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(Collection<InputDeviceRequest> inputDevices);

        /**
         * Settings for the devices.
         * 
         * @param inputDevices
         *        Settings for the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(InputDeviceRequest... inputDevices);

        /**
         * Settings for the devices. This is a convenience that creates an instance of the {@link List
         * <InputDeviceRequest>.Builder} avoiding the need to create one manually via {@link List
         * <InputDeviceRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputDeviceRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputDevices(List<InputDeviceRequest>)}.
         * 
         * @param inputDevices
         *        a consumer that will call methods on {@link List<InputDeviceRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDevices(List<InputDeviceRequest>)
         */
        Builder inputDevices(Consumer<InputDeviceRequest.Builder>... inputDevices);

        /**
         * Unique ID of the input.
         * 
         * @param inputId
         *        Unique ID of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * A list of security groups referenced by IDs to attach to the input.
         * 
         * @param inputSecurityGroups
         *        A list of security groups referenced by IDs to attach to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(Collection<String> inputSecurityGroups);

        /**
         * A list of security groups referenced by IDs to attach to the input.
         * 
         * @param inputSecurityGroups
         *        A list of security groups referenced by IDs to attach to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(String... inputSecurityGroups);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         *
         * @param mediaConnectFlows
         *        A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify
         *        as few as one Flow and presently, as many as two. The only requirement is when you have more than one
         *        is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         *
         * @param mediaConnectFlows
         *        A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify
         *        as few as one Flow and presently, as many as two. The only requirement is when you have more than one
         *        is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(MediaConnectFlowRequest... mediaConnectFlows);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         *
         * This is a convenience that creates an instance of the {@link List<MediaConnectFlowRequest>.Builder} avoiding
         * the need to create one manually via {@link List<MediaConnectFlowRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MediaConnectFlowRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaConnectFlows(List<MediaConnectFlowRequest>)}.
         * 
         * @param mediaConnectFlows
         *        a consumer that will call methods on {@link List<MediaConnectFlowRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlows(List<MediaConnectFlowRequest>)
         */
        Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder>... mediaConnectFlows);

        /**
         * Name of the input.
         * 
         * @param name
         *        Name of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty.
         *
         * @param sources
         *        The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
         *        redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<InputSourceRequest> sources);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty.
         *
         * @param sources
         *        The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
         *        redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(InputSourceRequest... sources);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty.
         *
         * This is a convenience that creates an instance of the {@link List<InputSourceRequest>.Builder} avoiding the
         * need to create one manually via {@link List<InputSourceRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputSourceRequest>.Builder#build()} is called immediately
         * and its result is passed to {@link #sources(List<InputSourceRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<InputSourceRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<InputSourceRequest>)
         */
        Builder sources(Consumer<InputSourceRequest.Builder>... sources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<InputDeviceRequest> inputDevices = DefaultSdkAutoConstructList.getInstance();

        private String inputId;

        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<MediaConnectFlowRequest> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String roleArn;

        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            destinations(model.destinations);
            inputDevices(model.inputDevices);
            inputId(model.inputId);
            inputSecurityGroups(model.inputSecurityGroups);
            mediaConnectFlows(model.mediaConnectFlows);
            name(model.name);
            roleArn(model.roleArn);
            sources(model.sources);
        }

        public final Collection<InputDestinationRequest.Builder> getDestinations() {
            if (destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return destinations != null ? destinations.stream().map(InputDestinationRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> InputDestinationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        public final Collection<InputDeviceRequest.Builder> getInputDevices() {
            if (inputDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return inputDevices != null ? inputDevices.stream().map(InputDeviceRequest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceRequest> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceRequest... inputDevices) {
            inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceRequest.Builder>... inputDevices) {
            inputDevices(Stream.of(inputDevices).map(c -> InputDeviceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputDevices(Collection<InputDeviceRequest.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copyFromBuilder(inputDevices);
        }

        public final String getInputId() {
            return inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final Collection<String> getInputSecurityGroups() {
            if (inputSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return inputSecurityGroups;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String... inputSecurityGroups) {
            inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        public final Collection<MediaConnectFlowRequest.Builder> getMediaConnectFlows() {
            if (mediaConnectFlows instanceof SdkAutoConstructList) {
                return null;
            }
            return mediaConnectFlows != null ? mediaConnectFlows.stream().map(MediaConnectFlowRequest::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlowRequest... mediaConnectFlows) {
            mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder>... mediaConnectFlows) {
            mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> MediaConnectFlowRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlowRequest.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copyFromBuilder(mediaConnectFlows);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<InputSourceRequest.Builder> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources != null ? sources.stream().map(InputSourceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> InputSourceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
