/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to identify the start of the clip.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTimecode implements SdkPojo, Serializable, ToCopyableBuilder<StartTimecode.Builder, StartTimecode> {
    private static final SdkField<String> TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timecode").getter(getter(StartTimecode::timecode)).setter(setter(Builder::timecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timecode;

    private StartTimecode(BuilderImpl builder) {
        this.timecode = builder.timecode;
    }

    /**
     * The timecode for the frame where you want to start the clip. Optional; if not specified, the clip starts at first
     * frame in the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
     * 
     * @return The timecode for the frame where you want to start the clip. Optional; if not specified, the clip starts
     *         at first frame in the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
     */
    public final String timecode() {
        return timecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTimecode)) {
            return false;
        }
        StartTimecode other = (StartTimecode) obj;
        return Objects.equals(timecode(), other.timecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTimecode").add("Timecode", timecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Timecode":
            return Optional.ofNullable(clazz.cast(timecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTimecode, T> g) {
        return obj -> g.apply((StartTimecode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartTimecode> {
        /**
         * The timecode for the frame where you want to start the clip. Optional; if not specified, the clip starts at
         * first frame in the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
         * 
         * @param timecode
         *        The timecode for the frame where you want to start the clip. Optional; if not specified, the clip
         *        starts at first frame in the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecode(String timecode);
    }

    static final class BuilderImpl implements Builder {
        private String timecode;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTimecode model) {
            timecode(model.timecode);
        }

        public final String getTimecode() {
            return timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public StartTimecode build() {
            return new StartTimecode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
