/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Resource configuration (codec, resolution, bitrate, ...)
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationResourceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationResourceSpecification.Builder, ReservationResourceSpecification> {
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelClass").getter(getter(ReservationResourceSpecification::channelClassAsString))
            .setter(setter(Builder::channelClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(ReservationResourceSpecification::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<String> MAXIMUM_BITRATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumBitrate").getter(getter(ReservationResourceSpecification::maximumBitrateAsString))
            .setter(setter(Builder::maximumBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()).build();

    private static final SdkField<String> MAXIMUM_FRAMERATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaximumFramerate").getter(getter(ReservationResourceSpecification::maximumFramerateAsString))
            .setter(setter(Builder::maximumFramerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumFramerate").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(ReservationResourceSpecification::resolutionAsString))
            .setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolution").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ReservationResourceSpecification::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> SPECIAL_FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpecialFeature").getter(getter(ReservationResourceSpecification::specialFeatureAsString))
            .setter(setter(Builder::specialFeature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specialFeature").build()).build();

    private static final SdkField<String> VIDEO_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoQuality").getter(getter(ReservationResourceSpecification::videoQualityAsString))
            .setter(setter(Builder::videoQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CLASS_FIELD,
            CODEC_FIELD, MAXIMUM_BITRATE_FIELD, MAXIMUM_FRAMERATE_FIELD, RESOLUTION_FIELD, RESOURCE_TYPE_FIELD,
            SPECIAL_FEATURE_FIELD, VIDEO_QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelClass;

    private final String codec;

    private final String maximumBitrate;

    private final String maximumFramerate;

    private final String resolution;

    private final String resourceType;

    private final String specialFeature;

    private final String videoQuality;

    private ReservationResourceSpecification(BuilderImpl builder) {
        this.channelClass = builder.channelClass;
        this.codec = builder.codec;
        this.maximumBitrate = builder.maximumBitrate;
        this.maximumFramerate = builder.maximumFramerate;
        this.resolution = builder.resolution;
        this.resourceType = builder.resourceType;
        this.specialFeature = builder.specialFeature;
        this.videoQuality = builder.videoQuality;
    }

    /**
     * Channel class, e.g. 'STANDARD'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return Channel class, e.g. 'STANDARD'
     * @see ChannelClass
     */
    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(channelClass);
    }

    /**
     * Channel class, e.g. 'STANDARD'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return Channel class, e.g. 'STANDARD'
     * @see ChannelClass
     */
    public final String channelClassAsString() {
        return channelClass;
    }

    /**
     * Codec, e.g. 'AVC'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link ReservationCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Codec, e.g. 'AVC'
     * @see ReservationCodec
     */
    public final ReservationCodec codec() {
        return ReservationCodec.fromValue(codec);
    }

    /**
     * Codec, e.g. 'AVC'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link ReservationCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Codec, e.g. 'AVC'
     * @see ReservationCodec
     */
    public final String codecAsString() {
        return codec;
    }

    /**
     * Maximum bitrate, e.g. 'MAX_20_MBPS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumBitrate}
     * will return {@link ReservationMaximumBitrate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumBitrateAsString}.
     * </p>
     * 
     * @return Maximum bitrate, e.g. 'MAX_20_MBPS'
     * @see ReservationMaximumBitrate
     */
    public final ReservationMaximumBitrate maximumBitrate() {
        return ReservationMaximumBitrate.fromValue(maximumBitrate);
    }

    /**
     * Maximum bitrate, e.g. 'MAX_20_MBPS'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumBitrate}
     * will return {@link ReservationMaximumBitrate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumBitrateAsString}.
     * </p>
     * 
     * @return Maximum bitrate, e.g. 'MAX_20_MBPS'
     * @see ReservationMaximumBitrate
     */
    public final String maximumBitrateAsString() {
        return maximumBitrate;
    }

    /**
     * Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumFramerate}
     * will return {@link ReservationMaximumFramerate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumFramerateAsString}.
     * </p>
     * 
     * @return Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
     * @see ReservationMaximumFramerate
     */
    public final ReservationMaximumFramerate maximumFramerate() {
        return ReservationMaximumFramerate.fromValue(maximumFramerate);
    }

    /**
     * Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maximumFramerate}
     * will return {@link ReservationMaximumFramerate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #maximumFramerateAsString}.
     * </p>
     * 
     * @return Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
     * @see ReservationMaximumFramerate
     */
    public final String maximumFramerateAsString() {
        return maximumFramerate;
    }

    /**
     * Resolution, e.g. 'HD'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ReservationResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionAsString}.
     * </p>
     * 
     * @return Resolution, e.g. 'HD'
     * @see ReservationResolution
     */
    public final ReservationResolution resolution() {
        return ReservationResolution.fromValue(resolution);
    }

    /**
     * Resolution, e.g. 'HD'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolution} will
     * return {@link ReservationResolution#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resolutionAsString}.
     * </p>
     * 
     * @return Resolution, e.g. 'HD'
     * @see ReservationResolution
     */
    public final String resolutionAsString() {
        return resolution;
    }

    /**
     * Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ReservationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     * @see ReservationResourceType
     */
    public final ReservationResourceType resourceType() {
        return ReservationResourceType.fromValue(resourceType);
    }

    /**
     * Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ReservationResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
     * @see ReservationResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialFeature}
     * will return {@link ReservationSpecialFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specialFeatureAsString}.
     * </p>
     * 
     * @return Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
     * @see ReservationSpecialFeature
     */
    public final ReservationSpecialFeature specialFeature() {
        return ReservationSpecialFeature.fromValue(specialFeature);
    }

    /**
     * Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specialFeature}
     * will return {@link ReservationSpecialFeature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specialFeatureAsString}.
     * </p>
     * 
     * @return Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
     * @see ReservationSpecialFeature
     */
    public final String specialFeatureAsString() {
        return specialFeature;
    }

    /**
     * Video quality, e.g. 'STANDARD' (Outputs only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoQuality} will
     * return {@link ReservationVideoQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #videoQualityAsString}.
     * </p>
     * 
     * @return Video quality, e.g. 'STANDARD' (Outputs only)
     * @see ReservationVideoQuality
     */
    public final ReservationVideoQuality videoQuality() {
        return ReservationVideoQuality.fromValue(videoQuality);
    }

    /**
     * Video quality, e.g. 'STANDARD' (Outputs only)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #videoQuality} will
     * return {@link ReservationVideoQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #videoQualityAsString}.
     * </p>
     * 
     * @return Video quality, e.g. 'STANDARD' (Outputs only)
     * @see ReservationVideoQuality
     */
    public final String videoQualityAsString() {
        return videoQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBitrateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumFramerateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specialFeatureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationResourceSpecification)) {
            return false;
        }
        ReservationResourceSpecification other = (ReservationResourceSpecification) obj;
        return Objects.equals(channelClassAsString(), other.channelClassAsString())
                && Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(maximumBitrateAsString(), other.maximumBitrateAsString())
                && Objects.equals(maximumFramerateAsString(), other.maximumFramerateAsString())
                && Objects.equals(resolutionAsString(), other.resolutionAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(specialFeatureAsString(), other.specialFeatureAsString())
                && Objects.equals(videoQualityAsString(), other.videoQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationResourceSpecification").add("ChannelClass", channelClassAsString())
                .add("Codec", codecAsString()).add("MaximumBitrate", maximumBitrateAsString())
                .add("MaximumFramerate", maximumFramerateAsString()).add("Resolution", resolutionAsString())
                .add("ResourceType", resourceTypeAsString()).add("SpecialFeature", specialFeatureAsString())
                .add("VideoQuality", videoQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelClass":
            return Optional.ofNullable(clazz.cast(channelClassAsString()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "MaximumBitrate":
            return Optional.ofNullable(clazz.cast(maximumBitrateAsString()));
        case "MaximumFramerate":
            return Optional.ofNullable(clazz.cast(maximumFramerateAsString()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolutionAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "SpecialFeature":
            return Optional.ofNullable(clazz.cast(specialFeatureAsString()));
        case "VideoQuality":
            return Optional.ofNullable(clazz.cast(videoQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationResourceSpecification, T> g) {
        return obj -> g.apply((ReservationResourceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationResourceSpecification> {
        /**
         * Channel class, e.g. 'STANDARD'
         * 
         * @param channelClass
         *        Channel class, e.g. 'STANDARD'
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(String channelClass);

        /**
         * Channel class, e.g. 'STANDARD'
         * 
         * @param channelClass
         *        Channel class, e.g. 'STANDARD'
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(ChannelClass channelClass);

        /**
         * Codec, e.g. 'AVC'
         * 
         * @param codec
         *        Codec, e.g. 'AVC'
         * @see ReservationCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationCodec
         */
        Builder codec(String codec);

        /**
         * Codec, e.g. 'AVC'
         * 
         * @param codec
         *        Codec, e.g. 'AVC'
         * @see ReservationCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationCodec
         */
        Builder codec(ReservationCodec codec);

        /**
         * Maximum bitrate, e.g. 'MAX_20_MBPS'
         * 
         * @param maximumBitrate
         *        Maximum bitrate, e.g. 'MAX_20_MBPS'
         * @see ReservationMaximumBitrate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationMaximumBitrate
         */
        Builder maximumBitrate(String maximumBitrate);

        /**
         * Maximum bitrate, e.g. 'MAX_20_MBPS'
         * 
         * @param maximumBitrate
         *        Maximum bitrate, e.g. 'MAX_20_MBPS'
         * @see ReservationMaximumBitrate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationMaximumBitrate
         */
        Builder maximumBitrate(ReservationMaximumBitrate maximumBitrate);

        /**
         * Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
         * 
         * @param maximumFramerate
         *        Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
         * @see ReservationMaximumFramerate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationMaximumFramerate
         */
        Builder maximumFramerate(String maximumFramerate);

        /**
         * Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
         * 
         * @param maximumFramerate
         *        Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
         * @see ReservationMaximumFramerate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationMaximumFramerate
         */
        Builder maximumFramerate(ReservationMaximumFramerate maximumFramerate);

        /**
         * Resolution, e.g. 'HD'
         * 
         * @param resolution
         *        Resolution, e.g. 'HD'
         * @see ReservationResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationResolution
         */
        Builder resolution(String resolution);

        /**
         * Resolution, e.g. 'HD'
         * 
         * @param resolution
         *        Resolution, e.g. 'HD'
         * @see ReservationResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationResolution
         */
        Builder resolution(ReservationResolution resolution);

        /**
         * Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * 
         * @param resourceType
         *        Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * @see ReservationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * 
         * @param resourceType
         *        Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
         * @see ReservationResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationResourceType
         */
        Builder resourceType(ReservationResourceType resourceType);

        /**
         * Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
         * 
         * @param specialFeature
         *        Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
         * @see ReservationSpecialFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationSpecialFeature
         */
        Builder specialFeature(String specialFeature);

        /**
         * Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
         * 
         * @param specialFeature
         *        Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
         * @see ReservationSpecialFeature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationSpecialFeature
         */
        Builder specialFeature(ReservationSpecialFeature specialFeature);

        /**
         * Video quality, e.g. 'STANDARD' (Outputs only)
         * 
         * @param videoQuality
         *        Video quality, e.g. 'STANDARD' (Outputs only)
         * @see ReservationVideoQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationVideoQuality
         */
        Builder videoQuality(String videoQuality);

        /**
         * Video quality, e.g. 'STANDARD' (Outputs only)
         * 
         * @param videoQuality
         *        Video quality, e.g. 'STANDARD' (Outputs only)
         * @see ReservationVideoQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationVideoQuality
         */
        Builder videoQuality(ReservationVideoQuality videoQuality);
    }

    static final class BuilderImpl implements Builder {
        private String channelClass;

        private String codec;

        private String maximumBitrate;

        private String maximumFramerate;

        private String resolution;

        private String resourceType;

        private String specialFeature;

        private String videoQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationResourceSpecification model) {
            channelClass(model.channelClass);
            codec(model.codec);
            maximumBitrate(model.maximumBitrate);
            maximumFramerate(model.maximumFramerate);
            resolution(model.resolution);
            resourceType(model.resourceType);
            specialFeature(model.specialFeature);
            videoQuality(model.videoQuality);
        }

        public final String getChannelClass() {
            return channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        public final String getCodec() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(ReservationCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final String getMaximumBitrate() {
            return maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        @Override
        public final Builder maximumBitrate(ReservationMaximumBitrate maximumBitrate) {
            this.maximumBitrate(maximumBitrate == null ? null : maximumBitrate.toString());
            return this;
        }

        public final void setMaximumBitrate(String maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        public final String getMaximumFramerate() {
            return maximumFramerate;
        }

        @Override
        public final Builder maximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
            return this;
        }

        @Override
        public final Builder maximumFramerate(ReservationMaximumFramerate maximumFramerate) {
            this.maximumFramerate(maximumFramerate == null ? null : maximumFramerate.toString());
            return this;
        }

        public final void setMaximumFramerate(String maximumFramerate) {
            this.maximumFramerate = maximumFramerate;
        }

        public final String getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public final Builder resolution(ReservationResolution resolution) {
            this.resolution(resolution == null ? null : resolution.toString());
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ReservationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getSpecialFeature() {
            return specialFeature;
        }

        @Override
        public final Builder specialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
            return this;
        }

        @Override
        public final Builder specialFeature(ReservationSpecialFeature specialFeature) {
            this.specialFeature(specialFeature == null ? null : specialFeature.toString());
            return this;
        }

        public final void setSpecialFeature(String specialFeature) {
            this.specialFeature = specialFeature;
        }

        public final String getVideoQuality() {
            return videoQuality;
        }

        @Override
        public final Builder videoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
            return this;
        }

        @Override
        public final Builder videoQuality(ReservationVideoQuality videoQuality) {
            this.videoQuality(videoQuality == null ? null : videoQuality.toString());
            return this;
        }

        public final void setVideoQuality(String videoQuality) {
            this.videoQuality = videoQuality;
        }

        @Override
        public ReservationResourceSpecification build() {
            return new ReservationResourceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
