/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for OutputDestinationSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputDestinationSettings.Builder, OutputDestinationSettings> {
    private static final SdkField<String> PASSWORD_PARAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PasswordParam").getter(getter(OutputDestinationSettings::passwordParam))
            .setter(setter(Builder::passwordParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordParam").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(OutputDestinationSettings::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(OutputDestinationSettings::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(OutputDestinationSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSWORD_PARAM_FIELD,
            STREAM_NAME_FIELD, URL_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String passwordParam;

    private final String streamName;

    private final String url;

    private final String username;

    private OutputDestinationSettings(BuilderImpl builder) {
        this.passwordParam = builder.passwordParam;
        this.streamName = builder.streamName;
        this.url = builder.url;
        this.username = builder.username;
    }

    /**
     * key used to extract the password from EC2 Parameter store
     * 
     * @return key used to extract the password from EC2 Parameter store
     */
    public final String passwordParam() {
        return passwordParam;
    }

    /**
     * Stream name for RTMP destinations (URLs of type rtmp://)
     * 
     * @return Stream name for RTMP destinations (URLs of type rtmp://)
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * A URL specifying a destination
     * 
     * @return A URL specifying a destination
     */
    public final String url() {
        return url;
    }

    /**
     * username for destination
     * 
     * @return username for destination
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDestinationSettings)) {
            return false;
        }
        OutputDestinationSettings other = (OutputDestinationSettings) obj;
        return Objects.equals(passwordParam(), other.passwordParam()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(url(), other.url()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputDestinationSettings").add("PasswordParam", passwordParam())
                .add("StreamName", streamName()).add("Url", url()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordParam":
            return Optional.ofNullable(clazz.cast(passwordParam()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDestinationSettings, T> g) {
        return obj -> g.apply((OutputDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDestinationSettings> {
        /**
         * key used to extract the password from EC2 Parameter store
         * 
         * @param passwordParam
         *        key used to extract the password from EC2 Parameter store
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordParam(String passwordParam);

        /**
         * Stream name for RTMP destinations (URLs of type rtmp://)
         * 
         * @param streamName
         *        Stream name for RTMP destinations (URLs of type rtmp://)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * A URL specifying a destination
         * 
         * @param url
         *        A URL specifying a destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * username for destination
         * 
         * @param username
         *        username for destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String passwordParam;

        private String streamName;

        private String url;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDestinationSettings model) {
            passwordParam(model.passwordParam);
            streamName(model.streamName);
            url(model.url);
            username(model.username);
        }

        public final String getPasswordParam() {
            return passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public OutputDestinationSettings build() {
            return new OutputDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
